/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.confluence.addon.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class AccxiaResponseWrapper
extends HttpServletResponseWrapper {
    private final ByteArrayOutputStream capture;
    private ServletOutputStream output;
    private PrintWriter writer;

    public AccxiaResponseWrapper(HttpServletResponse response) {
        super(response);
        this.capture = new ByteArrayOutputStream(response.getBufferSize());
    }

    public ServletOutputStream getOutputStream() {
        if (this.writer != null) {
            throw new IllegalStateException("getWriter() has already been called on this response.");
        }
        if (this.output == null) {
            this.output = new ServletOutputStream(){

                public void write(int b) throws IOException {
                    AccxiaResponseWrapper.this.capture.write(b);
                }

                public void flush() throws IOException {
                    AccxiaResponseWrapper.this.capture.flush();
                }

                public void close() throws IOException {
                    AccxiaResponseWrapper.this.capture.close();
                }

                public boolean isReady() {
                    return true;
                }

                public void setWriteListener(WriteListener writeListener) {
                }
            };
        }
        return this.output;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.output != null) {
            throw new IllegalStateException("getOutputStream() has already been called on this response.");
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), this.getCharacterEncoding()));
        }
        return this.writer;
    }

    public void prepareWriter() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(), this.getCharacterEncoding()));
        }
    }

    public byte[] getCaptureAsBytes() throws IOException {
        if (this.writer != null) {
            this.writer.close();
        } else if (this.output != null) {
            this.output.close();
        }
        return this.capture.toByteArray();
    }

    public String getCaptureAsString() throws IOException {
        return new String(this.getCaptureAsBytes(), this.getCharacterEncoding());
    }
}

