/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.confluence.addon.servlet.filter;

import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.User;
import com.atlassian.xwork.FileUploadUtils;
import de.accxia.confluence.addon.servlet.AccxiaRequestWrapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVE4367Filter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CVE4367Filter.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    private final Pattern fontMatrixPattern = Pattern.compile("\\/FontMatrix\\s+[\\[\\.\\-\\d\\s]*\\(");

    @Inject
    public CVE4367Filter(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().contains("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContentType=" + request.getContentType() + " RemoteAddr=" + request.getRemoteAddr());
            this.doLogInfo(request, response);
        }
        AccxiaRequestWrapper capturingRequestWrapper = new AccxiaRequestWrapper(httpServletRequest);
        MultiPartRequestWrapper multiPartRequestWrapper = FileUploadUtils.unwrapMultiPartRequest((HttpServletRequest)capturingRequestWrapper);
        Enumeration fileParameterNames = multiPartRequestWrapper.getFileParameterNames();
        if (LOG.isDebugEnabled()) {
            LOG.debug("====== FileParameterNames ====== ");
        }
        while (fileParameterNames.hasMoreElements()) {
            UploadedFile[] uploadedFiles;
            String fileName = (String)fileParameterNames.nextElement();
            for (UploadedFile uploadedFile : uploadedFiles = multiPartRequestWrapper.getFiles(fileName)) {
                File file;
                String content;
                Matcher matcher;
                if (!uploadedFile.isFile()) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AttachmentPath=" + uploadedFile.getAbsolutePath());
                    LOG.debug("uploadedFile=" + uploadedFile.getName());
                }
                if (!(uploadedFile.getContent() instanceof File) || !(matcher = this.fontMatrixPattern.matcher(content = FileUtils.readFileToString(file = (File)uploadedFile.getContent(), "UTF-8"))).find()) continue;
                LOG.debug("Matches found:" + matcher.group());
                httpServletResponse.sendError(403, "Found CVE-2024-4367 security issue");
                return;
            }
        }
        chain.doFilter((ServletRequest)capturingRequestWrapper, response);
    }

    private void doLogInfo(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        Enumeration attributeNames = httpServletRequest.getAttributeNames();
        LOG.debug("====== AttributeNames ====== ");
        while (attributeNames.hasMoreElements()) {
            String current = (String)attributeNames.nextElement();
            LOG.debug(current + "=" + httpServletRequest.getAttribute(current));
        }
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        LOG.debug("====== HeaderNames ====== ");
        while (headerNames.hasMoreElements()) {
            String current = (String)headerNames.nextElement();
            LOG.debug(current + "=" + httpServletRequest.getHeader(current));
        }
        LOG.debug("CVE4367Filter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
    }

    private TimeZone getTimeZone(User authUser) {
        if (authUser == null) {
            return TimeZone.getDefault();
        }
        ConfluenceUserPreferences prefs = this.userAccessor.getConfluenceUserPreferences(authUser);
        return prefs.getTimeZone().getWrappedTimeZone();
    }

    public String toInputStreamString(InputStream inputStream) {
        String text = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
        return text;
    }
}

