/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.confluence.addon.servlet.filter;

import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.User;
import de.accxia.confluence.addon.servlet.AccxiaResponseWrapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Optional;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVE4367DownloadFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CVE4367DownloadFilter.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final AttachmentManager attachmentManager;
    @ComponentImport
    private final I18nResolver i18nResolver;
    private final Pattern fontMatrixPattern = Pattern.compile("\\/FontMatrix\\s+[\\[\\.\\-\\d\\s]*\\(");

    @Inject
    public CVE4367DownloadFilter(UserManager userManager, UserAccessor userAccessor, AttachmentManager attachmentManager, I18nResolver i18nResolver) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.attachmentManager = attachmentManager;
        this.i18nResolver = i18nResolver;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String content;
        Matcher matcher;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (LOG.isDebugEnabled()) {
            this.doLogInfo(request, response);
        }
        AccxiaResponseWrapper capturingResponseWrapper = new AccxiaResponseWrapper(httpServletResponse);
        chain.doFilter(request, (ServletResponse)capturingResponseWrapper);
        if (!capturingResponseWrapper.getContentType().startsWith("application/x-download") && !capturingResponseWrapper.getContentType().startsWith("application/pdf")) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            Optional optionalAttachment = this.attachmentManager.findAttachmentForDownloadPath(httpServletRequest.getRequestURI() + "?" + httpServletRequest.getQueryString());
            String logMsg = request.getRemoteAddr() + "|" + (Serializable)(optionalAttachment.isPresent() ? (Serializable)this.attachmentManager.findAttachmentForDownloadPath(httpServletRequest.getRequestURI() + "?" + httpServletRequest.getQueryString()).get() : "N/A");
            LOG.debug("AttachmentForDownloadPath:" + logMsg);
        }
        if ((matcher = this.fontMatrixPattern.matcher(content = capturingResponseWrapper.getCaptureAsString())).find()) {
            LOG.debug("Matches found:" + matcher.group());
            capturingResponseWrapper.setStatus(400);
            capturingResponseWrapper.setContentType("application/json");
            capturingResponseWrapper.setCharacterEncoding("UTF-8");
            capturingResponseWrapper.prepareWriter();
            capturingResponseWrapper.getWriter().write("{ \"actionErrors\" : [\"Found CVE-2024-4367 security issue\"]}");
            capturingResponseWrapper.getWriter().flush();
            return;
        }
        capturingResponseWrapper.getWriter().write(content);
        capturingResponseWrapper.getWriter().flush();
    }

    private void doLogInfo(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        Enumeration attributeNames = httpServletRequest.getAttributeNames();
        LOG.debug("====== AttributeNames ====== ");
        while (attributeNames.hasMoreElements()) {
            String current = (String)attributeNames.nextElement();
            LOG.debug(current + "=" + httpServletRequest.getAttribute(current));
        }
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        LOG.debug("====== HeaderNames ====== ");
        while (headerNames.hasMoreElements()) {
            String current = (String)headerNames.nextElement();
            LOG.debug(current + "=" + httpServletRequest.getHeader(current));
        }
        LOG.debug("CVE4367Filter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
    }

    private TimeZone getTimeZone(User authUser) {
        if (authUser == null) {
            return TimeZone.getDefault();
        }
        ConfluenceUserPreferences prefs = this.userAccessor.getConfluenceUserPreferences(authUser);
        return prefs.getTimeZone().getWrappedTimeZone();
    }
}

