/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.confluence.addon.servlet.filter;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.confluence.addon.servlet.AccxiaRequestWrapper;
import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CVE4367JSONFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(CVE4367JSONFilter.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    private final Pattern fontMatrixPattern = Pattern.compile("\\/FontMatrix\\s+[\\[\\.\\-\\d\\s]*\\(");

    @Inject
    public CVE4367JSONFilter(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        AccxiaRequestWrapper capturingRequestWrapper;
        String body;
        Matcher matcher;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (httpServletRequest.getContentType() == null || !httpServletRequest.getContentType().contains("application/octet-stream")) {
            chain.doFilter(request, response);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("ContentType=" + request.getContentType() + " RemoteAddr=" + request.getRemoteAddr());
            this.doLogInfo(request, response);
        }
        if ((matcher = this.fontMatrixPattern.matcher(body = (capturingRequestWrapper = new AccxiaRequestWrapper(httpServletRequest)).getBody())).find()) {
            LOG.debug("Matches found:" + matcher.group());
            httpServletResponse.setStatus(403);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write("{ \"actionErrors\" : [\"Found CVE-2024-4367 security issue\"]}");
            response.getWriter().flush();
            return;
        }
        chain.doFilter((ServletRequest)capturingRequestWrapper, response);
    }

    private void doLogInfo(ServletRequest request, ServletResponse response) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        Enumeration attributeNames = httpServletRequest.getAttributeNames();
        LOG.debug("====== AttributeNames ====== ");
        while (attributeNames.hasMoreElements()) {
            String current = (String)attributeNames.nextElement();
            LOG.debug(current + "=" + httpServletRequest.getAttribute(current));
        }
        Enumeration headerNames = httpServletRequest.getHeaderNames();
        LOG.debug("====== HeaderNames ====== ");
        while (headerNames.hasMoreElements()) {
            String current = (String)headerNames.nextElement();
            LOG.debug(current + "=" + httpServletRequest.getHeader(current));
        }
        LOG.debug("CVE4367Filter doFilter requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
    }
}

