/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import com.atlassian.sal.api.user.UserManager;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

@Scanned
public class IsUserInGroupsCondition
extends SimpleUrlReadingCondition
implements Condition {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;

    @Inject
    public IsUserInGroupsCondition(UserManager userManager, UserAccessor userAccessor) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
    }

    protected boolean isConditionTrue() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        return this.isUserInGroups(user.getName(), "guests");
    }

    private boolean isUserInGroups(String userName, String groupNames) {
        if (groupNames == null || "".equals(groupNames)) {
            return false;
        }
        List groups = this.userAccessor.getGroupNamesForUserName(userName);
        if (groups != null) {
            for (String g : groupNames.replace(" ", "").split(",")) {
                if (!groups.contains(g)) continue;
                return true;
            }
        }
        return false;
    }

    protected String queryKey() {
        return "IUM";
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.isConditionTrue();
    }
}

