/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.event.events.security.LogoutEvent;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import javax.inject.Named;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Scanned
@ExportAsService(value={IUMListener.class})
@Named(value="IUMListener")
public class IUMListener
implements InitializingBean,
DisposableBean {
    @ComponentImport
    private final EventPublisher eventPublisher;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final IUMHelperService helperService;

    @Inject
    public IUMListener(EventPublisher eventPublisher, UserAccessor userAccessor, IUMHelperService helperService) {
        this.eventPublisher = eventPublisher;
        this.userAccessor = userAccessor;
        this.helperService = helperService;
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onLogoutEvent(LogoutEvent logoutEvent) {
        String userName = logoutEvent.getUsername();
        if (ConditionEvaluatorIUMImpl.isLicenseValid()) {
            ConfluenceUser user = this.userAccessor.getUserByName(userName);
            this.doLogout(user);
        }
    }

    public void doLogout(ConfluenceUser user) {
        CompletableFuture.runAsync(() -> this.helperService.moveUserToDisabled(user));
    }
}

