/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class IntelligentUserManagerServletFilter
implements Filter {
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerServletFilter(UserManager userManager, UserAccessor userAccessor, IUMHelperService helperService, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.helperService = helperService;
        this.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getMethod().equalsIgnoreCase("POST")) {
            CurrentUser currentUser;
            ConfluenceUser user;
            String[] unames = request.getParameterValues("os_username");
            if (unames.length == 0) {
                chain.doFilter(request, response);
            }
            if (this.helperService.isUserInGroups(user = this.userAccessor.getUserByName(unames[0]), DAO.getIUMGroups())) {
                chain.doFilter(request, response);
                return;
            }
            if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
                chain.doFilter(request, response);
                return;
            }
            if (unames != null && unames.length > 0 && this.userManager.authenticate(request.getParameterValues("os_username")[0], request.getParameterValues("os_password")[0]) && (currentUser = this.helperService.enableUserFromGroup(unames[0], httpRequest)) != null) {
                ConfluenceUser theUser = currentUser.user;
                if (theUser != null) {
                    chain.doFilter(request, response);
                    return;
                }
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
                return;
            }
        }
        chain.doFilter(request, response);
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String user = request.getParameter("os_username");
        String pass = request.getParameter("os_password");
        String dest = request.getParameter("os_destination");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("user", user);
        context.put("pass", pass);
        context.put("dest", dest);
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

