/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerCerberosFilter(UserManager userManager, UserAccessor userAccessor, IUMHelperService helperService, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.helperService = helperService;
        this.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/rest/api/user")) {
            chain.doFilter(request, response);
            return;
        }
        UserProfile userp = this.userManager.getRemoteUser(httpRequest);
        if (userp == null) {
            chain.doFilter(request, response);
            return;
        }
        ConfluenceUser user = this.userAccessor.getUserByKey(userp.getUserKey());
        if (this.helperService.isUserInGroups(user, DAO.getIUMGroups())) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
            chain.doFilter(request, response);
            return;
        }
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
        if (currentUser != null) {
            ConfluenceUser theUser = currentUser.user;
            if (theUser != null) {
                chain.doFilter(request, response);
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
            return;
        }
        chain.doFilter(request, response);
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("redirUrl", "/");
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

