/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.impl.OldestUser;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@ExportAsService(value={IUMHelperService.class})
public class IUMHelperServiceImpl
implements IUMHelperService {
    private static final Logger log = LoggerFactory.getLogger(IUMHelperServiceImpl.class);
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final RecentlyViewedManager recentlyViewedManager;
    public static final boolean MOVE_USER = false;

    @Inject
    public IUMHelperServiceImpl(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, RecentlyViewedManager recentlyViewedManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.recentlyViewedManager = recentlyViewedManager;
    }

    @Override
    public boolean isUserInGroups(ConfluenceUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        if (currentUser != null) {
            for (String group : groups.split(",")) {
                if (!this.userManager.isUserInGroup(currentUser.getKey(), group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String test() {
        return "Hallo Heiko";
    }

    public static double getNumeric(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return 0.0;
        }
        return d;
    }

    @Override
    public String moveUserFromGroupToGroup(ConfluenceUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = this.groupManager.getGroup(group);
            Group thetoGroup = this.groupManager.getGroup(toGroup);
            this.disableUserFromGroup(user, theGroup, thetoGroup, move, true);
            theLog.append(user.getName() + "=>" + thetoGroup.getName() + "</br>\n");
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ConfluenceUser user = this.userAccessor.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = this.groupManager.getGroup(group);
            for (ConfluenceUser it : this.userAccessor.getMembers(theGroup)) {
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(it, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public String disabelAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(this.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public void disableUserFromGroup(ConfluenceUser user, Group group, Group groupDisabled, boolean move) {
        this.disableUserFromGroup(user, group, groupDisabled, move, false);
    }

    public void disableUserFromGroup(ConfluenceUser user, Group group, Group groupDisabled, boolean move, boolean isWeb) {
        if (this.userManager.isUserInGroup(user.getKey(), group.getName())) {
            try {
                if (isWeb) {
                    this.groupManager.addMembership(groupDisabled, (User)user);
                }
                if (move) {
                    this.groupManager.removeMembership(group, (User)user);
                }
            }
            catch (EntityException | IllegalArgumentException e) {
                log.error("Exception: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        return this.enableUserFromGroup(user, request);
    }

    @Override
    public CurrentUser enableUserFromGroup(ConfluenceUser user, HttpServletRequest request) {
        try {
            int i;
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String queueSizeTxt = DAO.getQueueSize();
            String[] groups = null;
            String[] groupsDisabled = null;
            String[] queueSizes = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            if (queueSizeTxt != null) {
                queueSizes = queueSizeTxt.split(",");
            }
            Group[] enableGroups = new Group[groups.length];
            Group[] disableGroups = new Group[groups.length];
            for (int i2 = 0; i2 < groups.length; ++i2) {
                if (this.userManager.isUserInGroup(user.getKey(), groups[i2])) {
                    return new CurrentUser(user, 0);
                }
                enableGroups[i2] = this.groupManager.getGroup(groups[i2]);
                disableGroups[i2] = this.groupManager.getGroup(groupsDisabled[i2]);
            }
            CurrentUser currentUser = new CurrentUser(null, 0);
            for (i = 0; i < groups.length; ++i) {
                int queueSize = Integer.parseInt(queueSizes[i]);
                if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
                int noOfUsers = this.userAccessor.getMemberNamesAsList(enableGroups[i]).size();
                if (queueSize == 0 || noOfUsers < queueSize || this.disableOldestUser(enableGroups[i], disableGroups[i])) {
                    this.groupManager.addMembership(enableGroups[i], (User)user);
                    currentUser = new CurrentUser(user, 0);
                    break;
                }
                currentUser.noOfUsers = currentUser.noOfUsers > queueSize ? currentUser.noOfUsers : queueSize;
            }
            if (currentUser.user != null) {
                for (i = 0; i < groups.length; ++i) {
                    if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
                    this.groupManager.addMembership(enableGroups[i], (User)user);
                }
            }
            return currentUser;
        }
        catch (Exception e) {
            log.warn("Error parsing groups " + e.getMessage(), (Throwable)e);
            return new CurrentUser(null, 0);
        }
    }

    private OldestUser getOldestUser(Group group) {
        ConfluenceUser admin = null;
        ConfluenceUser oldUser = null;
        try {
            oldUser = AuthenticatedUserThreadLocal.get();
            Iterable admins = this.userAccessor.getMembers(this.groupManager.getGroup("confluence-administrators"));
            admin = (ConfluenceUser)admins.iterator().next();
            AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
        }
        catch (EntityException admins) {
            // empty catch block
        }
        Iterable users = this.userAccessor.getMembers(group);
        long oldestTS = 4120528639000L;
        ConfluenceUser oldestUser = null;
        for (ConfluenceUser user : users) {
            long lastTS;
            if (this.userManager.isAdmin(user.getKey()) || (lastTS = this.getlastViewByUser(user)) >= oldestTS) continue;
            if (lastTS == 0L) {
                return new OldestUser(user, 0L);
            }
            oldestTS = lastTS;
            oldestUser = user;
        }
        if (oldUser != null) {
            AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
        }
        return new OldestUser(oldestUser, oldestTS);
    }

    public long getlastViewByUser(ConfluenceUser user) {
        List recent = this.recentlyViewedManager.getRecentlyViewed(user.getKey(), true, 1);
        long lastViewed = 0L;
        if (recent.size() > 0) {
            lastViewed = ((RecentlyViewed)recent.get(0)).getLastSeen();
        }
        return lastViewed;
    }

    @Override
    public boolean disableOldestUser(Group group, Group groupDisabled) {
        OldestUser oldestUser = this.getOldestUser(group);
        if (oldestUser != null && oldestUser.user != null) {
            long now = new Timestamp(System.currentTimeMillis()).getTime();
            long diff = now - oldestUser.ts;
            long duration = Long.parseLong(DAO.getDuration()) * 1000L * 60L;
            if (oldestUser.ts == 0L || duration == 0L || diff > duration) {
                this.disableUserFromGroup(oldestUser.user, group, groupDisabled, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<OldestUser> getSortedUserListFromGroup(String group, int max, String filtergroup) {
        ArrayList<OldestUser> tmpUserList = new ArrayList<OldestUser>();
        ArrayList<OldestUser> userList = new ArrayList<OldestUser>();
        try {
            ArrayList theUsers;
            Group theGroup = this.groupManager.getGroup(group);
            Group filterGroup = this.groupManager.getGroup(filtergroup);
            ArrayList allUsers = null;
            ArrayList filterUsers = null;
            int numAll = 0;
            int numFilter = 0;
            String theFilter = null;
            allUsers = Lists.newArrayList((Iterable)this.userAccessor.getMembers(theGroup));
            if (allUsers == null) {
                return userList;
            }
            if (filtergroup == null || "".equals(filtergroup)) {
                theUsers = allUsers;
            } else {
                filterUsers = Lists.newArrayList((Iterable)this.userAccessor.getMembers(filterGroup));
                numAll = allUsers.size();
                if (filterUsers != null) {
                    numFilter = filterUsers.size();
                }
                if (numFilter == 0 || numAll == 0) {
                    return userList;
                }
                if (numAll > 0 && numFilter > numAll) {
                    theUsers = allUsers;
                    theFilter = filtergroup;
                } else {
                    theUsers = filterUsers;
                    theFilter = group;
                }
            }
            for (ConfluenceUser user : theUsers) {
                if (numFilter != 0 && !this.userManager.isUserInGroup(user.getKey(), group)) continue;
                long ts = this.getlastViewByUser(user);
                OldestUser oUser = new OldestUser(user, ts);
                tmpUserList.add(oUser);
            }
            Collections.sort(tmpUserList, new Comparator<OldestUser>(){

                @Override
                public int compare(OldestUser o1, OldestUser o2) {
                    return o1.ts.compareTo(o2.ts);
                }
            });
            int count = 0;
            for (OldestUser o : tmpUserList) {
                if (max == 0 || count < max) {
                    userList.add(o);
                }
                ++count;
            }
            return userList;
        }
        catch (Exception e) {
            return userList;
        }
    }

    @Override
    public void moveUserToDisabled(ConfluenceUser user) {
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (!this.userManager.isUserInGroup(user.getKey(), groups[i])) continue;
            try {
                Group theGroup = this.groupManager.getGroup(groups[i]);
                Group thetoGroup = this.groupManager.getGroup(groupsDisabled[i]);
                if (theGroup == null || thetoGroup == null) continue;
                this.disableUserFromGroup(user, theGroup, thetoGroup, true);
                continue;
            }
            catch (EntityException entityException) {
                // empty catch block
            }
        }
    }

    @Override
    public List<String> getOnlyDisabledUsers() {
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return new ArrayList<String>();
        }
        String[] IUMDisables = IUMDisabled.split(",");
        String[] IUMEnables = null;
        String IUMEnable = DAO.getIUMGroups();
        IUMEnables = IUMEnable == null || IUMEnable.length() == 0 ? new String[]{} : IUMEnable.split(",");
        HashSet usersSet = new HashSet();
        for (int i = 0; i < IUMDisables.length; ++i) {
            try {
                List disabledUserName = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(IUMDisables[i]));
                ArrayList enabledUserName = IUMEnables.length > i ? this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(IUMEnables[i])) : new ArrayList();
                disabledUserName.removeAll(enabledUserName);
                usersSet.addAll(disabledUserName);
                continue;
            }
            catch (EntityException e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>(usersSet);
    }
}

