/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config;

import com.atlassian.confluence.plugins.search.api.Searcher;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.api.model.SearchResults;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.persistence.dao.ConfluenceUserDao;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/search")
@Scanned
public class SearchService {
    private static final Logger LOG = LoggerFactory.getLogger(SearchService.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final TransactionTemplate transactionTemplate;
    @ComponentImport
    private final SearchManager searchManager;
    @ComponentImport
    private final PermissionManager permissionManager;
    @ComponentImport
    private final SettingsManager settingsManager;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    @ComponentImport
    private final PluginAccessor pluginAccessor;
    @ComponentImport
    private final Searcher searcher;
    @ComponentImport
    private final ConfluenceUserDao confluenceUserDao;

    @Inject
    public SearchService(UserManager userManager, TransactionTemplate transactionTemplate, SearchManager searchManager, PermissionManager permissionManager, SettingsManager settingsManager, PluginSettingsFactory pluginSettingsFactory, PluginAccessor pluginAccessor, Searcher searcher, ConfluenceUserDao confluenceUserDao) {
        this.userManager = userManager;
        this.transactionTemplate = transactionTemplate;
        this.searchManager = searchManager;
        this.permissionManager = permissionManager;
        this.settingsManager = settingsManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginAccessor = pluginAccessor;
        this.searcher = searcher;
        this.confluenceUserDao = confluenceUserDao;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/user")
    public Response searchUser(@QueryParam(value="cql") String query, @QueryParam(value="start") int start, @QueryParam(value="limit") int limit) {
        return this.doSearch(query, start, limit);
    }

    private Response doSearch(String query, int pageNo, int limit) {
        ArrayList response = new ArrayList();
        try {
            SearchQueryParameters.Builder builder = new SearchQueryParameters.Builder(query).startIndex(pageNo).pageSize(2 * limit).pluggableContentType(this.pluginAccessor, "userinfo").highlight(false);
            SearchQueryParameters searchQueryParameters = builder.build();
            SearchResults searchResults = this.searcher.search(searchQueryParameters, false);
            List listResults = searchResults.getResults();
            List<WrapUser> userList = listResults.stream().filter(x -> ContentTypeEnum.PERSONAL_INFORMATION.getRepresentation().equals(x.getContentType())).map(x -> new WrapUser(new User(x.getTitle(), x.getTitle()), x.getUrl())).collect(Collectors.toList());
            UserSearchResults userSearchResults = new UserSearchResults(userList, userList.size());
            return Response.ok((Object)userSearchResults).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @JsonSerialize
    public class UserSearchResults {
        public int totalSize;
        public List<WrapUser> results;

        public UserSearchResults(List<WrapUser> results, int totalSize) {
            this.totalSize = totalSize;
            this.results = results;
        }

        public int getTotalSize() {
            return this.totalSize;
        }

        public void setTotalSize(int totalSize) {
            this.totalSize = totalSize;
        }

        public List<WrapUser> getResults() {
            return this.results;
        }

        public void setResults(List<WrapUser> results) {
            this.results = results;
        }
    }

    @JsonSerialize
    public class User {
        public String username;
        public String displayName;

        public User(String username, String displayName) {
            this.username = username;
            this.displayName = displayName;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }

    @JsonSerialize
    public class WrapUser {
        public User user;
        public String url;

        public WrapUser(User user, String url) {
            this.user = user;
            this.url = url;
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    public class UserSort
    implements SearchSort {
        private static final String KEY = "username";
        private final SearchSort.Order order;

        public UserSort(SearchSort.Order order) {
            this.order = order;
        }

        public String getKey() {
            return KEY;
        }

        public SearchSort.Order getOrder() {
            return this.order;
        }
    }
}

