/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.search.SearchContext;
import com.atlassian.confluence.api.model.search.SearchOptions;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.plugins.search.api.Searcher;
import com.atlassian.confluence.plugins.search.api.model.SearchQueryParameters;
import com.atlassian.confluence.plugins.search.api.model.SearchResultList;
import com.atlassian.confluence.plugins.search.api.model.SearchResults;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Scanned
public class TestSearchServlet
extends HttpServlet {
    private static final long serialVersionUID = 3133173070139987213L;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private PluginLicenseManager pluginLicenseManager;
    @ComponentImport
    private final PluginController pluginController;
    @ComponentImport
    private final CQLSearchService cqlSearchService;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final Searcher searcher;
    @ComponentImport
    private final SearchManager searchManager;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final PluginAccessor pluginAccessor;

    @Inject
    public TestSearchServlet(PluginController pluginController, UserManager userManager, LoginUriProvider loginUriProvider, TemplateRenderer renderer, PluginLicenseManager pluginLicenseManager, CQLSearchService cqlSearchService, UserAccessor userAccessor, GroupManager groupManager, Searcher searcher, SearchManager searchManager, PluginAccessor pluginAccessor) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.pluginLicenseManager = pluginLicenseManager;
        this.pluginController = pluginController;
        this.cqlSearchService = cqlSearchService;
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.searcher = searcher;
        this.searchManager = searchManager;
        this.pluginAccessor = pluginAccessor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String cql = request.getParameter("cql");
            SearchQueryParameters.Builder builder = new SearchQueryParameters.Builder(cql).startIndex(0).pageSize(10).pluggableContentType(this.pluginAccessor, "userinfo").highlight(true);
            SearchQueryParameters searchQueryParameters = builder.build();
            SearchResults searchResults = this.searcher.search(searchQueryParameters, false);
            SearchResultList searchResultList = new SearchResultList(searchResults.getResults(), searchResults.getTotalSize(), searchResults.getExtendedTotalSize(), searchResults.getUuid().toString(), searchResults.getTimeSpent());
            response.setContentType("text/plain;charset=utf-8");
            searchResultList.getResults().stream().forEach(sr -> {
                try {
                    response.getWriter().write(sr.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            response.getWriter().write("Results:" + searchResultList.getResults());
        }
        catch (Exception e) {
            response.getWriter().write("Results:" + e.getMessage());
        }
    }

    private void doGet1(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String cql = request.getParameter("cql");
            Group groupDisable = this.groupManager.getGroup("ium_disable");
            ArrayList result = new ArrayList();
            Iterable iterable = this.userAccessor.getMembers(groupDisable);
            iterable.forEach(result::add);
            SearchOptions searchOptions = SearchOptions.builder().excerptStrategy(SearchOptions.Excerpt.HIGHLIGHT).fireSearchPerformed(true).build();
            Expansion expansion = new Expansion("user");
            PageResponse page = this.cqlSearchService.searchContent(cql, SearchContext.EMPTY, (PageRequest)new SimplePageRequest(0, 10), new Expansion[]{expansion});
            response.setContentType("text/plain;charset=utf-8");
            response.getWriter().write("Results:" + result);
            response.getWriter().write("Results:" + page.getResults());
        }
        catch (Exception e) {
            response.getWriter().write("Results:" + e.getMessage());
        }
    }
}

