/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import de.accxia.apps.confluence.ium.cache.PropertyCachedManager;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="DAO")
public class DAO {
    private static final Logger LOG = LoggerFactory.getLogger(DAO.class);
    private static final String MYUNIQUENAME = "IUM4Confluence";
    public static final String INACTIVITY_DURATION = "inactivityDuration";
    public static final String REPEAT_INTERVAL = "interval";
    public static final String STARTING_AT = "startingAt";
    public static final String STARTING_FROM = "startingFrom";
    public static final String WORKING_JOB = "workingJob";
    private static PluginSettings settings = null;
    public static PropertyCachedManager propertyCachedManager;

    @Inject
    public DAO(PropertyCachedManager propertyCachedManager) {
        DAO.propertyCachedManager = propertyCachedManager;
    }

    public static void setSettings(PluginSettings settings) {
        DAO.settings = settings;
        DAO.getValueByKey("sideLicense");
        DAO.getValueByKey("IUMGroup");
        DAO.getValueByKey("IUMGroupDIS");
        DAO.getValueByKey("duration");
        DAO.getValueByKey("queueSize");
        DAO.getValueByKey("samlIdp");
        DAO.getValueByKey("samlMapping");
        DAO.getValueByKey("samlRegex");
        DAO.getValueByKey("fromGroup");
        DAO.getValueByKey("toGroup");
    }

    public static PluginSettings getSettings() {
        return settings;
    }

    public static String getValueByKey(String field) {
        if (propertyCachedManager == null) {
            Object value;
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager is NULL");
            }
            if ((value = settings.get("IUM4Confluence." + field)) == null) {
                value = "";
                settings.put("IUM4Confluence." + field, (Object)"");
            }
            if ("null".equals(value)) {
                return null;
            }
            String res = String.valueOf(value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager is NULL field={} value={}", new Object[]{field, res});
            }
            return res;
        }
        String ourVal = propertyCachedManager.getKeyValue(field);
        if (ourVal == null) {
            Object value = settings.get("IUM4Confluence." + field);
            String res = String.valueOf(value);
            if (res == null || "null".equals(res)) {
                res = "";
                settings.put("IUM4Confluence." + field, (Object)res);
            }
            propertyCachedManager.setKeyValue(field, res);
            if (LOG.isDebugEnabled()) {
                LOG.debug("DAO.propertyCachedManager field={} value={}", new Object[]{field, res});
            }
            return res;
        }
        settings.put("IUM4Confluence." + field, (Object)ourVal);
        if (LOG.isDebugEnabled()) {
            LOG.debug("DAO.propertyCachedManager update field={} value={}", new Object[]{field, ourVal});
        }
        return ourVal;
    }

    public static String setValue(String field, String value) {
        if (value == null || !value.equals(DAO.getValueByKey(field))) {
            settings.put("IUM4Confluence." + field, (Object)value);
            if (propertyCachedManager != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("DAO.propertyCachedManager setValue field={} value={}", new Object[]{field, value});
                }
                propertyCachedManager.setKeyValue(field, value);
            }
        }
        return value;
    }

    public static void updateSideLicense(String value) {
        DAO.setValue("sideLicense", value);
    }

    public static String getSideLicense() {
        String sideLicense = DAO.getValueByKey("sideLicense");
        return sideLicense == null ? "" : sideLicense;
    }

    public static void updateIUMGroup(String value) {
        DAO.setValue("IUMGroup", value);
    }

    public static String getIUMGroups() {
        String IUMGroup = DAO.getValueByKey("IUMGroup");
        return IUMGroup == null ? "" : IUMGroup;
    }

    public static void updateIUMGroupDisabled(String value) {
        DAO.setValue("IUMGroupDIS", value);
    }

    public static String getIUMGroupsDisabled() {
        String IUMGroupDIS = DAO.getValueByKey("IUMGroupDIS");
        return IUMGroupDIS == null ? "" : IUMGroupDIS;
    }

    public static void updateDuration(String value) {
        DAO.setValue("duration", value);
    }

    public static String getDuration() {
        String duration = DAO.getValueByKey("duration");
        return duration == null ? "" : duration;
    }

    public static void updateQueueSize(String value) {
        DAO.setValue("queueSize", value);
    }

    public static String getQueueSize() {
        String queueSize = DAO.getValueByKey("queueSize");
        return queueSize == null ? "" : queueSize;
    }

    public static void updateSamlIdp(String value) {
        DAO.setValue("samlIdp", value);
    }

    public static String getSamlIdp() {
        String samlIdp = DAO.getValueByKey("samlIdp");
        return samlIdp == null ? "" : samlIdp;
    }

    public static void updateSamlMapping(String value) {
        DAO.setValue("samlMapping", value);
    }

    public static String getSamlMapping() {
        String samlMapping = DAO.getValueByKey("samlMapping");
        return samlMapping == null ? "" : samlMapping;
    }

    public static void updateSamlRegex(String value) {
        DAO.setValue("samlRegex", value);
    }

    public static String getSamlRegex() {
        String samlRegex = DAO.getValueByKey("samlRegex");
        return samlRegex == null ? "" : samlRegex;
    }

    public static String getInactivityDuration() {
        String inactivityDuration = DAO.getValueByKey(INACTIVITY_DURATION);
        if (inactivityDuration == null || "".equals(inactivityDuration)) {
            inactivityDuration = "5";
            DAO.updateInactivityDuration(inactivityDuration);
        }
        return inactivityDuration;
    }

    public static void updateInactivityDuration(String value) {
        DAO.setValue(INACTIVITY_DURATION, value);
    }

    public static String getRepeatInterval() {
        return DAO.getValueByKey(REPEAT_INTERVAL);
    }

    public static void updateRepeatInterval(String value) {
        DAO.setValue(REPEAT_INTERVAL, value);
    }

    public static void updateStartingAt(String value) {
        DAO.setValue(STARTING_AT, value);
    }

    public static String getStartingAt() {
        return DAO.getValueByKey(STARTING_AT);
    }

    public static void updateStartingFrom(String value) {
        DAO.setValue(STARTING_FROM, value);
    }

    public static String getStartingFrom() {
        return DAO.getValueByKey(STARTING_FROM);
    }

    public static void updateWorkingJob(String value) {
        DAO.setValue(WORKING_JOB, value);
    }

    public static String getWorkingJob() {
        return DAO.getValueByKey(WORKING_JOB);
    }
}

