/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.saml.SAMLHelper;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SAMLServlet
extends HttpServlet {
    private static final long serialVersionUID = -1585035763724104775L;
    private static final Logger log = LoggerFactory.getLogger(SAMLServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;

    @Inject
    public SAMLServlet(UserManager userManager, UserAccessor userAccessor, IUMHelperService helperService, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.helperService = helperService;
        this.renderer = renderer;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpServletRequest req = request;
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            response.getWriter().write("Error unlicensed");
            return;
        }
        if ("".equals(DAO.getSamlIdp())) {
            response.getWriter().write("Error no redir url configured");
            return;
        }
        HttpServletRequest httpRequest = request;
        HttpServletResponse httpResponse = response;
        String samlPar = req.getParameter("SAMLResponse");
        String user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (user == null) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user);
        if (this.helperService.isUserInGroups(confluenceUser, DAO.getIUMGroups())) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        if (!this.helperService.isUserInGroups(confluenceUser, DAO.getIUMGroupsDisabled())) {
            response.sendRedirect(DAO.getSamlIdp());
            return;
        }
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
        if (currentUser != null) {
            ConfluenceUser theUser = currentUser.user;
            if (theUser != null) {
                httpResponse.sendRedirect(DAO.getSamlIdp());
            } else {
                this.renderQueueVM(currentUser.noOfUsers, httpRequest, httpResponse);
                return;
            }
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

