/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IntelligentUserManagerCerberosFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerCerberosFilter.class);
    public static final String ORIGIN = "origin";
    public static final String URI_RESTORE = "secure/restore";
    public static final String URI_DISABLE = "secure/disable";
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;
    @ComponentImport
    private PageBuilderService pageBuilderService;
    @ComponentImport
    private final ApplicationProperties applicationProperties;

    @Inject
    public IntelligentUserManagerCerberosFilter(TemplateRenderer renderer, PageBuilderService pageBuilderService, ApplicationProperties applicationProperties, UserAccessor userAccessor, IUMHelperService helperService) {
        this.userAccessor = userAccessor;
        this.renderer = renderer;
        this.applicationProperties = applicationProperties;
        this.helperService = helperService;
        this.pageBuilderService = pageBuilderService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        ConfluenceUser user;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter doFilter requestURI =" + (httpRequest.getRequestURI() != null ? httpRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpRequest.getPathInfo() != null ? httpRequest.getPathInfo() : "N/A") + ", user=" + (httpRequest.getRemoteUser() != null ? httpRequest.getRemoteUser() : "N/A"));
        }
        if ((user = AuthenticatedUserThreadLocal.get()) == null) {
            chain.doFilter(request, response);
            return;
        }
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains("/logout.action")) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.helperService.isUserInGroups(user, DAO.getIUMGroupsDisabled())) {
            if (log.isDebugEnabled()) {
                log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " is not belong to IUM Disable :" + DAO.getIUMGroupsDisabled() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_DISABLE)) {
            String username;
            if (log.isDebugEnabled()) {
                log.debug("Received disable url=secure/disable " + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
            }
            if ((username = request.getParameter("username")) == null || username.length() == 0) {
                ((HttpServletResponse)response).sendRedirect(httpRequest.getContextPath() + "/");
                return;
            }
            if (username != null && username.length() > 0 && this.helperService.isUserInGroups(this.userAccessor.getUserByName(username), DAO.getIUMGroups())) {
                if (log.isDebugEnabled()) {
                    log.debug("Redirect to the saved url | referrer | base url " + this.applicationProperties.getBaseUrl());
                }
                this.doGlobalRedirect(httpRequest, (HttpServletResponse)response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("Redirect user " + username + " to the queue ");
            }
            this.renderQueueVM(this.helperService.getQuotaForGroupOfUsername(AuthenticatedUserThreadLocal.get()), httpRequest, (HttpServletResponse)response);
            return;
        }
        if (this.helperService.isUserInGroups(user, DAO.getIUMGroups())) {
            if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_RESTORE)) {
                if (log.isDebugEnabled()) {
                    log.debug("Received restore url=secure/restore  " + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
                }
                this.doGlobalRedirect(httpRequest, (HttpServletResponse)response);
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug("IntelligentUserManagerCerberosFilter user " + user.getName() + " belong to IUM Enable :" + DAO.getIUMGroups() + "  ==> forward doFilter ");
            }
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && (httpRequest.getRequestURI().contains("/rest/") || httpRequest.getRequestURI().contains("/json/"))) {
            chain.doFilter(request, response);
            return;
        }
        if (httpRequest.getRequestURI() != null && (httpRequest.getRequestURI().contains("/rest/IUM/latest/apps/check") || httpRequest.getRequestURI().contains("/rest/IUM/latest/apps/retry/"))) {
            chain.doFilter(request, response);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter try to enable user = " + user.getName() + ", for pathInfo=" + (httpRequest.getPathInfo() != null ? httpRequest.getPathInfo() : "N/A"));
        }
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
        if (log.isDebugEnabled()) {
            log.debug("IntelligentUserManagerCerberosFilter InputUser=" + user.getName() + (currentUser != null && currentUser.user != null ? "  ==> enabled with success=" + currentUser.user.getName() : " couldn't be enabled"));
        }
        if (currentUser != null) {
            if (currentUser.user != null) {
                if (httpRequest.getRequestURI() != null && httpRequest.getRequestURI().contains(URI_RESTORE) && httpRequest.getMethod().equalsIgnoreCase("POST")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Received secure/restore " + httpRequest.getRequestURI() + " ,servletPath=" + (httpRequest.getServletPath() != null ? httpRequest.getServletPath() : "NULL"));
                    }
                    this.doGlobalRedirect(httpRequest, (HttpServletResponse)response);
                    return;
                }
                chain.doFilter(request, response);
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, httpRequest, (HttpServletResponse)response);
            return;
        }
        chain.doFilter(request, response);
    }

    private void doGlobalRedirect(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String referrer;
        String origin = httpServletRequest.getParameter(ORIGIN);
        if (origin != null && origin.length() > 0) {
            if (log.isDebugEnabled()) {
                log.debug("doGlobalRedirect  ==> " + origin);
            }
            httpServletResponse.sendRedirect(origin);
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("IntelligentUserManagerCerberosFilter doGlobalRedirect requestURI =" + (httpServletRequest.getRequestURI() != null ? httpServletRequest.getRequestURI() : "N/A") + ", servletPath=" + (httpServletRequest.getServletPath() != null ? httpServletRequest.getServletPath() : "N/A") + ", pathInfo=" + (httpServletRequest.getPathInfo() != null ? httpServletRequest.getPathInfo() : "N/A") + ", referer=" + (httpServletRequest.getHeader("referer") != null ? httpServletRequest.getHeader("referer") : "N/A") + ", user=" + (httpServletRequest.getRemoteUser() != null ? httpServletRequest.getRemoteUser() : "N/A"));
            this.doWarnRequestData((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
        if (!((referrer = httpServletRequest.getHeader("referer")) == null || referrer.length() <= 0 || httpServletRequest.getRequestURI() == null || !httpServletRequest.getRequestURI().contains(URI_DISABLE) && !httpServletRequest.getRequestURI().contains(URI_RESTORE) || referrer.contains(URI_DISABLE) && referrer.contains(URI_RESTORE))) {
            httpServletResponse.sendRedirect(referrer);
            return;
        }
        if (log.isWarnEnabled()) {
            log.warn("doGlobalRedirect  ==> /");
        }
        httpServletResponse.sendRedirect(httpServletRequest.getContextPath() + "/");
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String referrer;
        String baseurl = this.applicationProperties.getBaseUrl();
        String origin = request.getParameter(ORIGIN);
        if (!(origin != null && origin.length() != 0 || (referrer = request.getHeader("referer")) == null || referrer.contains(URI_DISABLE) || referrer.contains("/login.jsp"))) {
            if (log.isDebugEnabled()) {
                log.debug("Retrive referrer from request: " + referrer + " update latest ref");
            }
            origin = referrer;
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put(ORIGIN, origin);
        context.put("redirUrl", this.applicationProperties.getBaseUrl());
        context.put("duration", DAO.getDuration());
        context.put("username", request.getRemoteUser());
        context.put("queueSize", noOfUsers);
        response.setContentType("text/html;charset=utf-8");
        this.pageBuilderService.assembler().resources().requireWebResource("de.accxia.apps.confluence.IUM.IUM4Confluence:IUM-Check-resources");
        this.pageBuilderService.assembler().assembled().drainIncludedResources().writeHtmlTags((Writer)response.getWriter(), UrlMode.RELATIVE);
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }

    private void doWarnRequestData(ServletRequest request, ServletResponse response) {
        try {
            Cookie[] cookies;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (httpRequest.getQueryString() != null) {
                log.warn("QueryString=" + httpRequest.getQueryString());
            }
            for (Cookie cookie : cookies = httpRequest.getCookies()) {
                log.warn(cookie.getName() + " " + cookie.getValue());
            }
            Enumeration headerNames = httpRequest.getHeaderNames();
            if (headerNames != null) {
                while (headerNames.hasMoreElements()) {
                    String headerName = (String)headerNames.nextElement();
                    log.warn(headerName + "=" + httpRequest.getHeader(headerName));
                }
            }
            Enumeration parameterNames = httpRequest.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                log.warn(parameterName + "=" + httpRequest.getParameter(parameterName));
            }
            Enumeration attributeNames = httpRequest.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = (String)attributeNames.nextElement();
                log.warn(attributeName + "=" + httpRequest.getParameter(attributeName));
            }
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }
}

