/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.User;
import com.google.common.collect.Lists;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.impl.OldestUser;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.Quota;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="IUMHelperService")
@ExportAsService(value={IUMHelperService.class})
public class IUMHelperServiceImpl
implements IUMHelperService {
    private static final Logger log = LoggerFactory.getLogger(IUMHelperServiceImpl.class);
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final RecentlyViewedManager recentlyViewedManager;
    public static final boolean MOVE_USER = false;

    @Inject
    public IUMHelperServiceImpl(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, RecentlyViewedManager recentlyViewedManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.recentlyViewedManager = recentlyViewedManager;
    }

    @Override
    public boolean isUserInGroups(ConfluenceUser currentUser, String groups) {
        if (groups == null || "".equals(groups)) {
            return true;
        }
        if (currentUser != null) {
            for (String group : groups.split(",")) {
                if (!this.userManager.isUserInGroup(currentUser.getKey(), group)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String test() {
        return "Hallo Heiko";
    }

    public static double getNumeric(String str) {
        double d = 0.0;
        try {
            d = Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            log.error("Exception:" + nfe.getMessage(), (Throwable)nfe);
            return 0.0;
        }
        return d;
    }

    @Override
    public String moveUserFromGroupToGroup(ConfluenceUser user, String group, String toGroup, boolean move) {
        if (group.equals(toGroup)) {
            return "";
        }
        try {
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = this.groupManager.getGroup(group);
            Group thetoGroup = this.groupManager.getGroup(toGroup);
            this.disableUserFromGroup(user, theGroup, thetoGroup, move, true);
            theLog.append(user.getName() + "=>" + thetoGroup.getName() + "</br>\n");
            return theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String moveUsersInListFromGroupToGroup(String[] selectedUsersList, String group, String toGroup, boolean move) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            for (String it : selectedUsersList) {
                ConfluenceUser user = this.userAccessor.getUserByName(it);
                if (user == null) continue;
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(user, group, toGroup, move));
            }
            String action = "Copied";
            if (move) {
                action = "Moved";
            }
            return "<b>" + action + " " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public String moveAllUsersFromGroupToGroup(String group, String toGroup) {
        if (group == null || toGroup == null || group.equals(toGroup)) {
            return "";
        }
        try {
            int totalRemoved = 0;
            if (group == null || "".equals(group)) {
                return null;
            }
            if (toGroup == null || "".equals(toGroup)) {
                return "";
            }
            StringBuffer theLog = new StringBuffer();
            Group theGroup = this.groupManager.getGroup(group);
            for (ConfluenceUser it : this.userAccessor.getMembers(theGroup)) {
                ++totalRemoved;
                theLog.append(this.moveUserFromGroupToGroup(it, group, toGroup, true));
            }
            return "<b>Moved " + totalRemoved + " Users</b> form Group <b>" + group + "</b> to Group <b>" + toGroup + "</b></br></br>\n" + theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public String disabelAllUsersFromTheEnabledGroups(String movegroup) {
        try {
            String group = DAO.getIUMGroups();
            String groupDisabled = DAO.getIUMGroupsDisabled();
            String[] groups = null;
            String[] groupsDisabled = null;
            if (group != null) {
                groups = group.split(",");
            }
            if (groupDisabled != null) {
                groupsDisabled = groupDisabled.split(",");
            }
            StringBuffer theLog = new StringBuffer();
            for (int i = 0; i < groups.length; ++i) {
                group = groups[i];
                if (!group.equals(movegroup)) continue;
                theLog.append(this.moveAllUsersFromGroupToGroup(group, groupsDisabled[i]));
            }
            return theLog.toString();
        }
        catch (Exception e) {
            log.error("Exception:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public void disableUserFromGroup(ConfluenceUser user, Group group, Group groupDisabled, boolean move) {
        this.disableUserFromGroup(user, group, groupDisabled, move, false);
    }

    public synchronized void disableUserFromGroup(ConfluenceUser user, Group group, Group groupDisabled, boolean move, boolean isWeb) {
        if (log.isDebugEnabled()) {
            log.info("IUMHelperService disableUserFromGroup: user {}  from group {} to group {} , move={} isWeb={} ", new Object[]{user.getName(), group.getName(), groupDisabled.getName(), move, isWeb});
        }
        try {
            if (this.groupManager.hasMembership(group, (User)user)) {
                if (isWeb) {
                    this.groupManager.addMembership(groupDisabled, (User)user);
                    if (log.isDebugEnabled()) {
                        log.info("IUMHelperService disableUserFromGroup: addMembership : user {} to group {} ", new Object[]{user.getName(), groupDisabled.getName()});
                    }
                }
                if (move) {
                    this.groupManager.removeMembership(group, (User)user);
                    if (log.isDebugEnabled()) {
                        log.info("IUMHelperService disableUserFromGroup: removeMembership : user {} from group {} ", new Object[]{user.getName(), group.getName()});
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public CurrentUser enableUserFromGroup(String userName, HttpServletRequest request) {
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        return this.enableUserFromGroup(user, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CurrentUser enableUserFromGroup(ConfluenceUser user, HttpServletRequest request) {
        Class<IUMHelperServiceImpl> clazz = IUMHelperServiceImpl.class;
        synchronized (IUMHelperServiceImpl.class) {
            int maxQueueSize = 0;
            try {
                int i;
                String group = DAO.getIUMGroups();
                String groupDisabled = DAO.getIUMGroupsDisabled();
                String queueSizeTxt = DAO.getQueueSize();
                String[] groupsEnabled = null;
                String[] groupsDisabled = null;
                String[] queueSizes = null;
                if (group != null) {
                    groupsEnabled = group.split(",");
                }
                if (groupDisabled != null) {
                    groupsDisabled = groupDisabled.split(",");
                }
                if (queueSizeTxt != null) {
                    queueSizes = queueSizeTxt.split(",");
                }
                Group[] enableGroups = new Group[groupsEnabled.length];
                Group[] disableGroups = new Group[groupsEnabled.length];
                for (int i2 = 0; i2 < groupsEnabled.length; ++i2) {
                    if (this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i2])) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return new CurrentUser(user, 0);
                    }
                    enableGroups[i2] = this.groupManager.getGroup(groupsEnabled[i2]);
                    disableGroups[i2] = this.groupManager.getGroup(groupsDisabled[i2]);
                }
                CurrentUser currentUser = new CurrentUser(null, 0);
                for (i = 0; i < groupsEnabled.length; ++i) {
                    int queueSize = Integer.parseInt(queueSizes[i]);
                    if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("IUMHelperService user " + user.getName() + " found in disabled group :" + groupsDisabled[i]);
                    }
                    int noOfUsers = this.userAccessor.getMemberNamesAsList(enableGroups[i]).size();
                    if (log.isDebugEnabled()) {
                        log.debug("IUMHelperService enable group=" + enableGroups[i] + ", has=" + noOfUsers + ", max_allow=" + queueSize);
                    }
                    int n = maxQueueSize = maxQueueSize > queueSize ? maxQueueSize : queueSize;
                    if (queueSize != 0 && noOfUsers >= queueSize && !this.disableOldestUser(enableGroups[i], disableGroups[i]) || queueSize != 0 && noOfUsers > queueSize) continue;
                    boolean guard = true;
                    try {
                        this.groupManager.addMembership(enableGroups[i], (User)user);
                        if (log.isDebugEnabled()) {
                            log.debug("IUMHelperService add user " + user.getName() + " to " + enableGroups[i].getName());
                        }
                    }
                    catch (Exception e) {
                        log.error("Error :" + e.getMessage(), (Throwable)e);
                        guard = false;
                    }
                    currentUser = new CurrentUser((ConfluenceUser)(guard ? user : null), 0);
                    break;
                }
                if (currentUser.user != null) {
                    for (i = 0; i < groupsEnabled.length; ++i) {
                        if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i]) || this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i])) continue;
                        this.groupManager.addMembership(enableGroups[i], (User)user);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("IUMHelperService multi-group add user " + user.getName() + " to " + enableGroups[i].getName());
                    }
                } else if (currentUser.noOfUsers == 0) {
                    currentUser.noOfUsers = maxQueueSize;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return currentUser;
            }
            catch (Exception e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return new CurrentUser(null, maxQueueSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OldestUser getOldestUser(Group group) {
        oldUser = null;
        oldestTS = 4120528639000L;
        oldestUser = null;
        try {
            oldUser = AuthenticatedUserThreadLocal.get();
            admins = this.userAccessor.getMembers(this.groupManager.getGroup("confluence-administrators"));
            admin = (ConfluenceUser)admins.iterator().next();
            AuthenticatedUserThreadLocal.set((ConfluenceUser)admin);
            if (IUMHelperServiceImpl.log.isDebugEnabled()) {
                IUMHelperServiceImpl.log.debug("IUMHelperService run as admin : " + admin.getName());
            }
            users = this.userAccessor.getMembers(group);
lbl12:
            // 3 sources

            for (ConfluenceUser user : users) {
                if (this.userManager.isAdmin(user.getKey()) || (lastTS = this.getlastViewByUser(user)) >= oldestTS) continue;
                if (lastTS != 0L) ** GOTO lbl-1000
                var13_12 = new OldestUser(user, 0L);
                ** GOTO lbl27
            }
            ** GOTO lbl34
        }
        catch (EntityException e) {
            block8: {
                try {
                    IUMHelperServiceImpl.log.error("EntityException " + e.getMessage(), (Throwable)e);
                }
                catch (Throwable var14_13) {
                    AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
                    if (IUMHelperServiceImpl.log.isDebugEnabled() == false) throw var14_13;
                    IUMHelperServiceImpl.log.debug("IUMHelperService back to user : " + oldUser != null ? oldUser.getName() : "NULL");
                    throw var14_13;
                }
lbl27:
                // 1 sources

                AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
                if (IUMHelperServiceImpl.log.isDebugEnabled() == false) return var13_12;
                IUMHelperServiceImpl.log.debug("IUMHelperService back to user : " + oldUser != null ? oldUser.getName() : "NULL");
                return var13_12;
lbl-1000:
                // 1 sources

                {
                    oldestTS = lastTS;
                    oldestUser = user;
                    ** GOTO lbl12
lbl34:
                    // 1 sources

                    if (!IUMHelperServiceImpl.log.isDebugEnabled()) break block8;
                    if (oldestUser != null) {
                        IUMHelperServiceImpl.log.debug("IUMHelperService DISABLED Oldest User : " + oldestUser.getName() + ", " + new Date(oldestTS).toString());
                        break block8;
                    }
                    IUMHelperServiceImpl.log.debug("IUMHelperService DISABLED Oldest User : N/A");
                }
            }
            AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
            if (IUMHelperServiceImpl.log.isDebugEnabled() == false) return new OldestUser(oldestUser, oldestTS);
            IUMHelperServiceImpl.log.debug("IUMHelperService back to user : " + oldUser != null ? oldUser.getName() : "NULL");
            return new OldestUser(oldestUser, oldestTS);
            AuthenticatedUserThreadLocal.set((ConfluenceUser)oldUser);
            if (IUMHelperServiceImpl.log.isDebugEnabled() == false) return new OldestUser(oldestUser, oldestTS);
            IUMHelperServiceImpl.log.debug("IUMHelperService back to user : " + oldUser != null ? oldUser.getName() : "NULL");
            return new OldestUser(oldestUser, oldestTS);
        }
    }

    public long getlastViewByUser(ConfluenceUser user) {
        List recent = this.recentlyViewedManager.getRecentlyViewed(user.getKey(), true, 1);
        long lastViewed = 0L;
        if (recent.size() > 0) {
            lastViewed = ((RecentlyViewed)recent.get(0)).getLastSeen();
        }
        return lastViewed;
    }

    @Override
    public boolean disableOldestUser(Group group, Group groupDisabled) {
        OldestUser oldestUser = this.getOldestUser(group);
        if (oldestUser != null && oldestUser.user != null) {
            long now = new Timestamp(System.currentTimeMillis()).getTime();
            long diff = now - oldestUser.ts;
            long duration = Long.parseLong(DAO.getDuration()) * 1000L * 60L;
            if (oldestUser.ts == 0L || duration == 0L || diff > duration) {
                this.disableUserFromGroup(oldestUser.user, group, groupDisabled, true);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<OldestUser> getSortedUserListFromGroup(String group, int max, String filtergroup) {
        ArrayList<OldestUser> tmpUserList = new ArrayList<OldestUser>();
        ArrayList<OldestUser> userList = new ArrayList<OldestUser>();
        try {
            ArrayList theUsers;
            Group theGroup = this.groupManager.getGroup(group);
            Group filterGroup = this.groupManager.getGroup(filtergroup);
            ArrayList allUsers = null;
            ArrayList filterUsers = null;
            int numAll = 0;
            int numFilter = 0;
            String theFilter = null;
            allUsers = Lists.newArrayList((Iterable)this.userAccessor.getMembers(theGroup));
            if (allUsers == null) {
                return userList;
            }
            if (filtergroup == null || "".equals(filtergroup)) {
                theUsers = allUsers;
            } else {
                filterUsers = Lists.newArrayList((Iterable)this.userAccessor.getMembers(filterGroup));
                numAll = allUsers.size();
                if (filterUsers != null) {
                    numFilter = filterUsers.size();
                }
                if (numFilter == 0 || numAll == 0) {
                    return userList;
                }
                if (numAll > 0 && numFilter > numAll) {
                    theUsers = allUsers;
                    theFilter = filtergroup;
                } else {
                    theUsers = filterUsers;
                    theFilter = group;
                }
            }
            for (ConfluenceUser user : theUsers) {
                if (numFilter != 0 && !this.userManager.isUserInGroup(user.getKey(), group)) continue;
                long ts = this.getlastViewByUser(user);
                OldestUser oUser = new OldestUser(user, ts);
                tmpUserList.add(oUser);
            }
            Collections.sort(tmpUserList, new Comparator<OldestUser>(){

                @Override
                public int compare(OldestUser o1, OldestUser o2) {
                    return o1.ts.compareTo(o2.ts);
                }
            });
            int count = 0;
            for (OldestUser o : tmpUserList) {
                if (max == 0 || count < max) {
                    userList.add(o);
                }
                ++count;
            }
            return userList;
        }
        catch (Exception e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
            return userList;
        }
    }

    @Override
    public void moveUserToDisabled(ConfluenceUser user) {
        String group = DAO.getIUMGroups();
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String[] groups = null;
        String[] groupsDisabled = null;
        if (group != null) {
            groups = group.split(",");
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        for (int i = 0; i < groups.length; ++i) {
            if (!this.userManager.isUserInGroup(user.getKey(), groups[i])) continue;
            try {
                Group theGroup = this.groupManager.getGroup(groups[i]);
                Group thetoGroup = this.groupManager.getGroup(groupsDisabled[i]);
                if (theGroup == null || thetoGroup == null) continue;
                this.disableUserFromGroup(user, theGroup, thetoGroup, true);
                continue;
            }
            catch (EntityException e) {
                log.error("Exception " + e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public List<String> getOnlyDisabledUsers() {
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return new ArrayList<String>();
        }
        String[] IUMDisables = IUMDisabled.split(",");
        String[] IUMEnables = null;
        String IUMEnable = DAO.getIUMGroups();
        IUMEnables = IUMEnable == null || IUMEnable.length() == 0 ? new String[]{} : IUMEnable.split(",");
        HashSet usersSet = new HashSet();
        for (int i = 0; i < IUMDisables.length; ++i) {
            try {
                List disabledUserName = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(IUMDisables[i]));
                ArrayList enabledUserName = IUMEnables.length > i ? this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(IUMEnables[i])) : new ArrayList();
                disabledUserName.removeAll(enabledUserName);
                usersSet.addAll(disabledUserName);
                continue;
            }
            catch (EntityException e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        return new ArrayList<String>(usersSet);
    }

    @Override
    public List<ConfluenceUser> getOnlyEnabledUsers(long refTS) {
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return new ArrayList<ConfluenceUser>();
        }
        String IUMEnable = DAO.getIUMGroups();
        if (IUMEnable == null || IUMEnable.length() == 0) {
            return new ArrayList<ConfluenceUser>();
        }
        String[] IUMDisables = IUMDisabled.split(",");
        String[] IUMEnables = IUMEnable.split(",");
        HashMap<UserKey, ConfluenceUser> map = new HashMap<UserKey, ConfluenceUser>();
        for (int i = 0; i < IUMEnables.length; ++i) {
            try {
                ArrayList disabledUserName = IUMDisables.length > i ? this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(IUMDisables[i])) : new ArrayList();
                Iterable users = this.userAccessor.getMembers(this.groupManager.getGroup(IUMEnables[i]));
                for (ConfluenceUser user2 : users) {
                    if (!disabledUserName.contains(user2.getName()) || this.userManager.isAdmin(user2.getKey())) continue;
                    long lastTS = this.getlastViewByUser(user2);
                    if (lastTS < refTS) {
                        map.put(user2.getKey(), user2);
                        continue;
                    }
                    if (refTS >= lastTS || !map.containsKey(user2.getKey())) continue;
                    map.put(user2.getKey(), null);
                }
                continue;
            }
            catch (EntityException e) {
                log.error("EntityException: " + e.getMessage(), (Throwable)e);
            }
        }
        List<ConfluenceUser> inactiveUsers = map.values().stream().filter(user -> user != null).collect(Collectors.toList());
        return inactiveUsers;
    }

    @Override
    public void removeUserFromGroup(ConfluenceUser user, String enableGroup) {
        try {
            String[] enableGroups = enableGroup.split(",");
            List groups = this.userAccessor.getGroups((User)user).getCurrentPage();
            for (Group group : groups) {
                if (!IUMHelperServiceImpl.check(enableGroups, group.getName())) continue;
                this.groupManager.removeMembership(group, (User)user);
                if (!log.isDebugEnabled()) continue;
                log.info("IUMHelperService removeUserFromGroup: removeMembership : user {} from group {} ", new Object[]{user.getName(), group.getName()});
            }
        }
        catch (EntityException e) {
            log.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public int getQuotaForGroupOfUsername(ConfluenceUser user) {
        int quota = 0;
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String[] groupsDisabled = null;
        String[] queueSizes = null;
        if (user == null) {
            return quota;
        }
        if (groupDisabled != null) {
            groupsDisabled = groupDisabled.split(",");
        }
        if (queueSizeTxt != null) {
            queueSizes = queueSizeTxt.split(",");
        }
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (!this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i])) continue;
            return Integer.parseInt(queueSizes[i]);
        }
        return quota;
    }

    @Override
    public Quota checkCanGetFreeSlots(String username) throws EntityException {
        String groupDisabled = DAO.getIUMGroupsDisabled();
        String queueSizeTxt = DAO.getQueueSize();
        String groupEnabled = DAO.getIUMGroups();
        ConfluenceUser user = this.userAccessor.getUserByName(username);
        if (groupEnabled == null || groupDisabled == null || queueSizeTxt == null || user == null) {
            return Quota.Empty;
        }
        String[] groupsDisabled = groupDisabled.split(",");
        String[] groupsEnabled = groupEnabled.split(",");
        String[] queueSizes = queueSizeTxt.split(",");
        for (int i = 0; i < groupsDisabled.length; ++i) {
            if (queueSizes[i] == null || queueSizes[i].length() == 0) continue;
            int qs = Integer.parseInt(queueSizes[i]);
            int queue = 0;
            if (this.userManager.isUserInGroup(user.getKey(), groupsDisabled[i]) && (queue = this.userAccessor.getMemberNamesAsList(this.groupManager.getGroup(groupsEnabled[i])).size()) < qs) {
                return new Quota(qs, qs - queue);
            }
            if (!this.userManager.isUserInGroup(user.getKey(), groupsEnabled[i])) continue;
            return new Quota(qs, 1);
        }
        return Quota.Empty;
    }

    private static <T> Set<T> getIntersection(List<T> list1, List<T> list2) {
        HashSet<T> result = new HashSet<T>();
        for (T elem1 : list1) {
            if (!list2.contains(elem1)) continue;
            result.add(elem1);
        }
        return result;
    }

    private static boolean check(String[] array, String value) {
        boolean test = false;
        for (String item : array) {
            if (!item.equals(value)) continue;
            test = true;
            break;
        }
        return test;
    }
}

