/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import de.accxia.apps.confluence.ium.cache.PropertyCachedManager;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.JobService;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="PropertyCacheEntryAdapter")
public class PropertyCacheEntryAdapter
implements CacheEntryListener<String, String> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCachedManager.class);
    private final JobService jobService;

    @Inject
    public PropertyCacheEntryAdapter(JobService jobService) {
        this.jobService = jobService;
    }

    public void onAdd(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onAdd " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onEvict(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onEvict " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
    }

    public void onRemove(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onRemove " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
    }

    public void onUpdate(@Nonnull CacheEntryEvent<String, String> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " old=" + (String)cacheEntryEvent.getOldValue() + " new=" + (String)cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("workingJob")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String workingJob = (String)cacheEntryEvent.getValue();
            try {
                if ("on".equalsIgnoreCase(workingJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=ON isWorking=" + this.jobService.isWorking());
                    }
                    if (this.jobService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop JobService " + new Date());
                        this.jobService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start JobService " + new Date());
                    this.jobService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=OFF isWorking=" + this.jobService.isWorking());
                    }
                    if (this.jobService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop JobService " + new Date());
                        this.jobService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + (String)cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

