/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMClusterJob;
import de.accxia.apps.confluence.ium.job.IUMFakeJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/job")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobRestController.class);
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;

    @Inject
    public JobRestController(MonitorJobRunner monitorJobRunner, IUMHelperService helperService) {
        this.monitorJobRunner = monitorJobRunner;
        this.helperService = helperService;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("repeat_interval", DAO.getRepeatInterval());
        map.put("starting_from", DAO.getStartingFrom());
        map.put("enable_groups", DAO.getIUMGroups());
        map.put("disable_groups", DAO.getIUMGroupsDisabled());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking()));
        if (this.monitorJobRunner.getJobDetails() != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails().toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey()) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking()) {
            map.put("lastRunForJob", this.monitorJobRunner.getLastRunForJob() != null ? this.monitorJobRunner.getLastRunForJob().toString() : "N/A");
            map.put("lastSuccessfulRunForJob", this.monitorJobRunner.getLastSuccessfulRunForJob() != null ? this.monitorJobRunner.getLastSuccessfulRunForJob().toString() : "N/A");
            map.put("nextRunDate", this.monitorJobRunner.getNextRunDate() != null ? this.monitorJobRunner.getNextRunDate().toString() : "N/A");
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateRepeatInterval(repeatinterval);
        DAO.updateStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule();
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMJobData(), IUMFakeJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule();
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        try {
            long duration = Long.parseLong(DAO.getInactivityDuration()) * 60L * 1000L;
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("enable_groups", (Serializable)((Object)DAO.getIUMGroups()));
            parameters.put("inactivity_interval", Long.valueOf(duration));
            IUMClusterJob.getInstance().setHelperService(this.helperService);
            IUMClusterJob.getInstance().doProcessingJob(parameters);
            String response = "{\"message\":\"success\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }
}

