/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config.model;

import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.ArrayList;
import java.util.List;

@JsonSerialize
public class UserSearchResults {
    public int totalSize;
    public List<WrapUser> results;

    public static UserSearchResults buildFrom(SearchResults searchResults) {
        ArrayList<WrapUser> resultList = new ArrayList<WrapUser>(searchResults.size());
        for (SearchResult r : searchResults) {
            if (r.getType() == null) continue;
            User user = new User(r.getField("username"), r.getDisplayTitle(), r.getField("userKey"));
            user.profilePicture = new ProfilePicture(r.getField("profile-picture-url"));
            WrapUser wrapUser = new WrapUser(user, r.getField("urlPath"));
            if (wrapUser == null) continue;
            resultList.add(wrapUser);
        }
        UserSearchResults userSearchResults = new UserSearchResults(resultList, searchResults.getUnfilteredResultsCount());
        return userSearchResults;
    }

    public UserSearchResults(List<WrapUser> results, int totalSize) {
        this.totalSize = totalSize;
        this.results = results;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public List<WrapUser> getResults() {
        return this.results;
    }

    public void setResults(List<WrapUser> results) {
        this.results = results;
    }

    @JsonSerialize
    public static class ProfilePicture {
        public String path;
        public int width;
        public int height;
        public boolean isDefault;

        public ProfilePicture(String path) {
            this(path, 48, 48, false);
        }

        public ProfilePicture(String path, int width, int height, boolean isDefault) {
            this.path = path;
            this.width = width;
            this.height = height;
            this.isDefault = isDefault;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public void setDefault(boolean aDefault) {
            this.isDefault = aDefault;
        }
    }

    @JsonSerialize
    public static class User {
        public String type = "known";
        public String username;
        public String displayName;
        public String userKey;
        public ProfilePicture profilePicture;

        public User(String username, String displayName, String userKey) {
            this.username = username;
            this.displayName = displayName;
            this.userKey = userKey;
            this.type = "known";
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getUserKey() {
            return this.userKey;
        }

        public void setUserKey(String userKey) {
            this.userKey = userKey;
        }
    }

    @JsonSerialize
    public static class WrapUser {
        public User user;
        public String url;

        public WrapUser(User user, String url) {
            this.user = user;
            this.url = url;
        }

        public User getUser() {
            return this.user;
        }

        public void setUser(User user) {
            this.user = user;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

