/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.plugins.mentions.api.MentionFinder;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.util.EmailUtil;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.IUMMentionService;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class HookListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(HookListener.class);
    public static final String PLUGIN_KEY = "de.accxia.apps.confluence.IUM.IUM4Confluence";
    @ConfluenceImport
    private final LocalNotificationService notificationService;
    @ConfluenceImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final MentionFinder mentionFinder;
    @ComponentImport
    private final UserAccessor userAccessor;
    private final IUMHelperService helperService;
    private final IUMMentionService iumMentionService;

    @Inject
    public HookListener(EventPublisher eventPublisher, UserAccessor userAccessor, LocalNotificationService notificationService, NotificationManager notificationManager, MentionFinder mentionFinder, IUMHelperService helperService, IUMMentionService iumMentionService) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.userAccessor = userAccessor;
        this.notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)notificationManager);
        this.notificationService = (LocalNotificationService)Preconditions.checkNotNull((Object)notificationService);
        this.helperService = helperService;
        this.iumMentionService = iumMentionService;
        this.mentionFinder = mentionFinder;
    }

    @EventListener
    public void blogPostEvents(BlogPostEvent event) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        this.tryToMentionsUser4DisableGroup((ContentEvent)event);
        this.tryToNotifyInAppUser4DisableGroup((ContentEvent)event);
        this.tryToNotifyMailsUser4DisableGroup((ContentEvent)event);
        LOG.info("BlogPostEvent " + event);
    }

    @EventListener
    public void pageEvents(PageEvent event) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        this.tryToMentionsUser4DisableGroup((ContentEvent)event);
        this.tryToNotifyInAppUser4DisableGroup((ContentEvent)event);
        this.tryToNotifyMailsUser4DisableGroup((ContentEvent)event);
        LOG.info("PageEvent " + event);
    }

    @EventListener
    public void commentEvents(CommentEvent event) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        this.tryToMentionsUser4DisableGroup((ContentEvent)event);
        this.tryToNotifyInAppUser4DisableGroup((ContentEvent)event);
        this.tryToNotifyMailsUser4DisableGroup((ContentEvent)event);
        LOG.info("CommentEvent " + event);
    }

    private void tryToMentionsUser4DisableGroup(ContentEvent event) {
        String[] IUMDisables;
        Set mentionedUsernames = this.mentionFinder.getMentionedUsernames(event.getContent().getBodyContent());
        if (mentionedUsernames == null || mentionedUsernames.size() == 0) {
            return;
        }
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return;
        }
        for (String ium_disable : IUMDisables = IUMDisabled.split(",")) {
            mentionedUsernames.stream().forEach(userName -> {
                ConfluenceUser mentionedUser = this.userAccessor.getUserByName(userName);
                if (this.helperService.isUserInGroups(mentionedUser, ium_disable)) {
                    try {
                        this.iumMentionService.sendMentions(mentionedUser, event.getContent());
                    }
                    catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void tryToNotifyInAppUser4DisableGroup(ContentEvent event) {
        String[] IUMDisables;
        List notificationList = this.notificationManager.getNotificationsByContent(event.getContent());
        if (notificationList == null || notificationList.size() == 0) {
            return;
        }
        String IUMDisabled = DAO.getIUMGroupsDisabled();
        if (IUMDisabled == null || IUMDisabled.length() == 0) {
            return;
        }
        for (String ium_disable : IUMDisables = IUMDisabled.split(",")) {
            notificationList.stream().forEach(n -> {
                if (this.helperService.isUserInGroups(n.getReceiver(), ium_disable)) {
                    try {
                        Notification nx = this.createNotification(event);
                        if (nx != null) {
                            nx = this.sendNotification((User)n.getReceiver(), nx);
                            LOG.info("Notification Status :  " + nx.getStatus());
                        }
                    }
                    catch (Exception e) {
                        LOG.error("Exception " + e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    private void tryToNotifyMailsUser4DisableGroup(ContentEvent event) {
        if (EmailUtil.checkMailServer()) {
            String IUMDisabled = DAO.getIUMGroupsDisabled();
            if (IUMDisabled == null || IUMDisabled.length() == 0) {
                return;
            }
            String[] IUMDisables = IUMDisabled.split(",");
            List notificationList = this.notificationManager.getNotificationsByContent(event.getContent());
            for (String ium_disable : IUMDisables) {
                notificationList.stream().forEach(n -> {
                    if (this.helperService.isUserInGroups(n.getReceiver(), ium_disable)) {
                        try {
                            if (n.getReceiver().getEmail() != null) {
                                EmailUtil.sendMail(n.getReceiver().getEmail(), event.getContent().getDisplayTitle(), event.getContent().getBodyContent().getBody(), true);
                            }
                        }
                        catch (Exception e) {
                            LOG.error("Exception " + e.getMessage(), (Throwable)e);
                        }
                    }
                });
            }
        }
    }

    private Notification createNotification(ContentEvent event) {
        NotificationBuilder notificationBuilder = new NotificationBuilder().application(PLUGIN_KEY).groupingId(PLUGIN_KEY);
        if (event instanceof CommentEvent) {
            CommentEvent commentEvent = (CommentEvent)event;
            notificationBuilder.title(commentEvent.getComment().getDisplayTitle()).itemTitle(commentEvent.getComment().getContainer().getTitle()).description(commentEvent.getComment().getBodyAsString());
        } else if (event instanceof PageEvent) {
            PageEvent pageEvent = (PageEvent)event;
            notificationBuilder.title(pageEvent.getPage().getTitle()).itemTitle(pageEvent.getPage().getDisplayTitle()).description(pageEvent.getPage().getBodyAsString());
        } else if (event instanceof BlogPostEvent) {
            BlogPostEvent blogPostEvent = (BlogPostEvent)event;
            notificationBuilder.title(blogPostEvent.getBlogPost().getDisplayTitle()).itemTitle(blogPostEvent.getBlogPost().getTitle()).description(blogPostEvent.getBlogPost().getBodyAsString());
        } else {
            return null;
        }
        return notificationBuilder.createNotification();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private Notification sendNotification(User user, Notification notification) throws InterruptedException, ExecutionException {
        return (Notification)this.notificationService.createOrUpdate(user.getName(), notification).get();
    }
}

