/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);
    private static String EMAIL_TEMPLATE_HEAD = "<html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\"><meta http-equiv=\"Content-Security-Policy\" content=\"upgrade-insecure-requests\">\n</head>";
    private static String EMAIL_TEMPLATE_BODY_1 = "<body><div><div align='center'><div class=\"open_email\" style=\"margin-left: 8px; margin-top: 8px; margin-bottom: 8px; margin-right: 8px;\"><div> <br> <span class=\"genEmailContent\"> <div style=\"display: inline-block;word-break: break-all;box-sizing:border-box;text-align:center; border:1px solid #f6f6f6; background-color:#f7f8fa; margin:auto; padding:20px 0 30px; font-family:'helvetica neue',PingFangSC-Light,arial,'hiragino sans gb','microsoft yahei ui','microsoft yahei',simsun,sans-serif\"> <div class=\"main-content\"> <table style=\"font-weight:300;margin-bottom:10px;border-collapse:collapse\"> <tbody> <tr> <td> <p style=\"height:2px;background-color: #00a4ff;border: 0;font-size:0;padding:0;margin-top:20px;margin-left:20px;margin-right:20px;\"></p> <div style=\"min-width:600px;background-color:#fff; padding:23px 10px;box-shadow: 0px 1px 1px 0px rgba(122, 55, 55, 0.2);text-align:left;margin-left:20px;margin-right:20px;\"> <table style=\"font-weight:300;margin-bottom:10px;border-collapse:collapse;text-align:left;margin-left:10px\"> <tbody> <tr style=\"font-weight:300\"> <td style=\"text-align:left;\"> <h1 style=\"font-size: 20px; line-height: 36px; margin: 0px 0px 22px;\"> ";
    private static String EMAIL_TEMPLATE_BODY_2 = " </h1><p style=\"font-size:14px;color:#333; line-height:24px; margin:0;\">";
    private static String EMAIL_TEMPLATE_BODY_3 = " </p></td><td style=\"width:3.2%;max-width:30px;\"></td></tr></tbody> </table> </div> <div style=\"text-align:center; font-size:12px; line-height:18px; color:#999\"> <table style=\"display: inline-block;font-weight:300;margin-bottom:10px;border-collapse:collapse\"> <tbody> <tr style=\"font-weight:300\"> <td style=\"width:3.2%;max-width:30px;\"></td> <td> <p style=\"text-align:center; margin:20px auto 14px auto;font-size:12px;color:#999;white-space:nowrap;\">";
    private static String EMAIL_TEMPLATE_BODY_4 = "</p></td><td style=\"width:3.2%;max-width:30px;\"></td></tr></tbody> </table> </div> </td> </tr> </tbody> </table> </div> </div> </span> </div> </div> </div></div>";
    private static String EMAIL_TEMPLATE_END = "</body></html>";

    public static void sendMail(String to, String subject, String body, Boolean isSupportsHTML) throws MailException {
        Email email = new Email(to);
        email.setSubject(subject);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(EMAIL_TEMPLATE_HEAD).append(EMAIL_TEMPLATE_BODY_1).append(subject).append(EMAIL_TEMPLATE_BODY_2).append(body).append(EMAIL_TEMPLATE_BODY_3).append(EMAIL_TEMPLATE_BODY_4).append(EMAIL_TEMPLATE_END);
        email.setBody(stringBuffer.toString());
        if (isSupportsHTML.booleanValue()) {
            email.setMimeType("text/html");
        }
        EmailUtil.sendMail(email);
    }

    public static boolean checkMailServer() {
        MailServerManager mailServerManager = (MailServerManager)ComponentLocator.getComponent(MailServerManager.class);
        SMTPMailServer mailServer = mailServerManager.getDefaultSMTPMailServer();
        return !Objects.isNull(mailServer);
    }

    private static void sendMail(Email email) throws MailException {
        MailServerManager mailServerManager = (MailServerManager)ComponentLocator.getComponent(MailServerManager.class);
        SMTPMailServer mailServer = mailServerManager.getDefaultSMTPMailServer();
        log.info(" ------> sendMail successful " + new Date().toString());
        if (Objects.isNull(mailServer)) {
            log.error("SMTP mail server is not found. Please configure new SMTP mail server.");
        } else {
            mailServer.send(email);
        }
    }
}

