/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.config.model;

import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.crowd.embedded.api.User;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.accxia.apps.confluence.ium.config.model.AccxiaProfilePicture;
import de.accxia.apps.confluence.ium.config.model.AccxiaUser;
import de.accxia.apps.confluence.ium.config.model.AccxiaUserEx;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonSerialize
public class UserSearchResults {
    public int totalSize;
    public List<AccxiaUserEx> results;

    public static UserSearchResults buildFrom(SearchResults searchResults) {
        ArrayList<AccxiaUserEx> resultList = new ArrayList<AccxiaUserEx>(searchResults.size());
        for (SearchResult r : searchResults) {
            if (r.getType() == null) continue;
            AccxiaUser user = new AccxiaUser(r.getField("username"), r.getDisplayTitle(), r.getField("userKey"));
            user.profilePicture = new AccxiaProfilePicture(r.getField("profile-picture-url"));
            AccxiaUserEx wrapUser = new AccxiaUserEx(user, r.getField("urlPath"));
            if (wrapUser == null) continue;
            resultList.add(wrapUser);
        }
        UserSearchResults userSearchResults = new UserSearchResults(resultList, searchResults.getUnfilteredResultsCount());
        return userSearchResults;
    }

    public static UserSearchResults buildFrom(List<User> users, Map<String, ConfluenceUser> mapConfluenceUser) throws UnsupportedEncodingException {
        ArrayList<AccxiaUserEx> resultList = new ArrayList<AccxiaUserEx>(users.size());
        for (User user : users) {
            ConfluenceUser confluenceUser = mapConfluenceUser.get(user.getName());
            String key = confluenceUser != null && confluenceUser.getKey() != null ? confluenceUser.getKey().getStringValue() : String.valueOf(user.getDirectoryId());
            AccxiaUser usr = new AccxiaUser(user.getName(), user.getDisplayName(), key);
            AccxiaUserEx wrapUser = new AccxiaUserEx(usr, "/display/~" + URLEncoder.encode(user.getName(), StandardCharsets.UTF_8.toString()));
            resultList.add(wrapUser);
        }
        UserSearchResults userSearchResults = new UserSearchResults(resultList, users.size());
        return userSearchResults;
    }

    public UserSearchResults(List<AccxiaUserEx> results, int totalSize) {
        this.totalSize = totalSize;
        this.results = results;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public void setTotalSize(int totalSize) {
        this.totalSize = totalSize;
    }

    public List<AccxiaUserEx> getResults() {
        return this.results;
    }

    public void setResults(List<AccxiaUserEx> results) {
        this.results = results;
    }
}

