/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.spring.scanner.extension;

import com.atlassian.plugin.spring.scanner.extension.GenericOsgiServiceFactoryBean;
import com.atlassian.plugin.spring.scanner.extension.OsgiServiceFactoryBeanFactory;
import com.atlassian.plugin.spring.scanner.util.SpringDMUtil;
import java.util.Hashtable;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class ExportedSeviceManager {
    private final Hashtable<Integer, GenericOsgiServiceFactoryBean> exporters = new Hashtable();

    public ServiceRegistration registerService(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, Class<?> ... interfaces) throws Exception {
        GenericOsgiServiceFactoryBean osgiExporter = this.createExporter(bundleContext, bean, beanName, serviceProps, interfaces);
        int hashCode = System.identityHashCode(bean);
        this.exporters.put(hashCode, osgiExporter);
        return osgiExporter.getObject();
    }

    public boolean hasService(Object bean) {
        int hashCode = System.identityHashCode(bean);
        return this.exporters.containsKey(hashCode);
    }

    public void unregisterService(BundleContext bundleContext, Object bean) {
        int hashCode = System.identityHashCode(bean);
        GenericOsgiServiceFactoryBean exporter = this.exporters.get(hashCode);
        if (null != exporter) {
            exporter.destroy();
            this.exporters.remove(hashCode);
        }
    }

    private GenericOsgiServiceFactoryBean createExporter(BundleContext bundleContext, Object bean, String beanName, Map<String, Object> serviceProps, Class<?> ... interfaces) throws Exception {
        OsgiServiceFactoryBeanFactory osgiServiceFactoryBeanFactory = SpringDMUtil.getInstance().getOsgiServiceFactoryBeanFactory();
        return osgiServiceFactoryBeanFactory.createExporter(bundleContext, bean, beanName, serviceProps, interfaces);
    }
}

