/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.saml.SAMLHelper;
import de.accxia.apps.confluence.ium.servlet.filter.AccxiaResponseWrapper;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class IntelligentUserManagerSAMLFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(IntelligentUserManagerSAMLFilter.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    private final IUMHelperService helperService;

    @Inject
    public IntelligentUserManagerSAMLFilter(UserManager userManager, UserAccessor userAccessor, IUMHelperService helperService, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.helperService = helperService;
        this.renderer = renderer;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String myRedirLocation = "/";
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            chain.doFilter(request, response);
            return;
        }
        if ("".equals(DAO.getSamlIdp())) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String samlPar = httpRequest.getParameter("SAMLResponse");
        String user = SAMLHelper.getSAMLUserFromSAMLResponse(samlPar);
        if (user == null) {
            chain.doFilter(request, response);
            return;
        }
        ConfluenceUser confluenceUser = this.userAccessor.getUserByName(user);
        if (confluenceUser == null) {
            AccxiaResponseWrapper myWrapper = new AccxiaResponseWrapper(httpResponse);
            chain.doFilter(request, (ServletResponse)myWrapper);
            myRedirLocation = myWrapper.getRedirectLocation();
            confluenceUser = this.userAccessor.getUserByName(user);
            this.helperService.moveUserToDisabled(confluenceUser);
        }
        if (this.helperService.isUserInGroups(confluenceUser, DAO.getIUMGroups())) {
            chain.doFilter(request, response);
            return;
        }
        if (!this.helperService.isUserInGroups(confluenceUser, DAO.getIUMGroupsDisabled())) {
            chain.doFilter(request, response);
            return;
        }
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, httpRequest);
        if (currentUser != null) {
            ConfluenceUser theUser = currentUser.user;
            if (theUser != null) {
                httpResponse.sendRedirect(myRedirLocation);
                return;
            }
            this.renderQueueVM(currentUser.noOfUsers, httpRequest, httpResponse);
            return;
        }
    }

    private void renderQueueVM(int noOfUsers, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("duration", DAO.getDuration());
        context.put("queueSize", noOfUsers);
        context.put("redirUrl", DAO.getSamlIdp());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/queue_IUM.vm", context, (Writer)response.getWriter());
    }
}

