/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.upm.api.license.PluginLicenseManager;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUM;
import de.accxia.apps.confluence.ium.conditions.ConditionType;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.side.LicenseData;
import de.accxia.apps.confluence.ium.side.VerifyMessage;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="LoginIsPluginLicensedCondition")
public class ConditionEvaluatorIUMImpl
implements ConditionEvaluatorIUM {
    @ComponentImport
    private static PluginLicenseManager licenseManager;
    @ComponentImport
    private final ApplicationConfiguration applicationConfig;
    @ComponentImport
    private final PluginSettingsFactory pluginSettingsFactory;
    private static final Object CONFLUENCE_SETUP_SERVER_ID;
    private static LicenseData sideLicense;
    private static String ourServerID;
    static PluginSettings settings;

    public static String getOurServerID() {
        return ourServerID;
    }

    public static LicenseData getSideLicense() {
        return sideLicense;
    }

    public static void setSideLicense() {
        sideLicense = VerifyMessage.checkSideLicenses(settings);
    }

    public static void deleteSideLicense() {
        sideLicense = null;
    }

    @Inject
    public ConditionEvaluatorIUMImpl(PluginLicenseManager licenseManager, ApplicationConfiguration applicationConfig, PluginSettingsFactory pluginSettingsFactory) {
        ConditionEvaluatorIUMImpl.licenseManager = licenseManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        settings = pluginSettingsFactory.createGlobalSettings();
        this.applicationConfig = applicationConfig;
        ourServerID = (String)applicationConfig.getProperty(CONFLUENCE_SETUP_SERVER_ID);
        DAO.setSettings(settings);
        ConditionEvaluatorIUMImpl.setSideLicense();
    }

    @Override
    public boolean evaluate(ConditionType type) {
        switch (type) {
            case LICENSED: {
                return ConditionEvaluatorIUMImpl.isLicenseValid();
            }
            case SIDELICENSED: {
                return VerifyMessage.isSideLicenseValid(sideLicense, ourServerID);
            }
            case WRONGSIDELICENSE: {
                return !"".equals(DAO.getSideLicense());
            }
        }
        return false;
    }

    public static boolean isLicenseValid() {
        boolean isLicensed = false;
        if (VerifyMessage.isSideLicenseValid(sideLicense, ourServerID)) {
            return true;
        }
        return isLicensed;
    }

    static {
        CONFLUENCE_SETUP_SERVER_ID = "confluence.setup.server.id";
        sideLicense = null;
        settings = null;
    }
}

