/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.job.IUMClusterJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ExportAsService(value={JobService.class})
@Named(value="jobService")
public class JobService {
    private static final Log LOG = LogFactory.getLog(JobService.class);
    private final MonitorJobRunner monitorJobRunner;

    @Inject
    public JobService(MonitorJobRunner monitorJobRunner) {
        this.monitorJobRunner = monitorJobRunner;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JobService call start");
            }
            this.monitorJobRunner.doUnSchedule();
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMJobData(), IUMClusterJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error((Object)("Exception" + msg), (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JobService doStop");
            }
            this.monitorJobRunner.doUnSchedule();
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error((Object)("Exception" + msg), (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking();
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails();
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate();
    }
}

