/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={MonitorJobRunnerImpl.class})
@Named(value="monitorJobRunner")
public class MonitorJobRunnerImpl
implements MonitorJobRunner,
JobRunner {
    private static Logger LOG = LoggerFactory.getLogger(MonitorJobRunnerImpl.class);
    private final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)MonitorJobRunnerImpl.class.getName());
    private JobId JOB_ID = null;
    private IJob job = null;
    private Date nextRunDate = null;
    @ConfluenceImport
    private SchedulerService confluenceSchedulerService;
    private RunDetailsDao runDetailsDao;
    private final IUMHelperService helperService;

    @Inject
    public MonitorJobRunnerImpl(SchedulerService confluenceSchedulerService, IUMHelperService helperService) {
        this.confluenceSchedulerService = confluenceSchedulerService;
        this.helperService = helperService;
        try {
            this.runDetailsDao = (RunDetailsDao)ComponentLocator.getComponent(RunDetailsDao.class);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    public JobRunnerResponse runJob(JobRunnerRequest jobRequest) {
        try {
            if (LOG.isInfoEnabled()) {
                LOG.info("Begin ProcessingJob at " + new Date());
            }
            this.doProcessingJob(jobRequest.getJobConfig().getParameters());
            if (LOG.isInfoEnabled()) {
                LOG.info("End ProcessingJob at " + new Date());
            }
        }
        catch (Exception e) {
            LOG.error("Exception ProcessingJob: " + e.getMessage(), (Throwable)e);
            return JobRunnerResponse.aborted((String)("Task aborted due to the following error : " + e.getMessage()));
        }
        return JobRunnerResponse.success();
    }

    @Override
    public String doSchedule(JobData jobData, IJob job) throws SchedulerServiceException {
        this.job = job;
        this.confluenceSchedulerService.registerJobRunner(this.JOB_RUNNER_KEY, (JobRunner)this);
        this.nextRunDate = this.createFirstRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)this.JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withParameters(jobData.getParameters()).withSchedule(Schedule.forInterval((long)jobData.getRepeatInterval(), (Date)this.nextRunDate));
        try {
            this.JOB_ID = JobId.of((String)MonitorJobRunnerImpl.class.getName());
            this.confluenceSchedulerService.scheduleJob(this.JOB_ID, jobConfig);
            LOG.warn("Job schedule with id =" + this.JOB_ID.toString());
            return this.JOB_RUNNER_KEY.toString();
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new SchedulerServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void doUnSchedule() throws SchedulerServiceException {
        try {
            if (this.JOB_ID != null) {
                LOG.warn("Stopping..." + this.JOB_ID.toString());
                this.confluenceSchedulerService.unscheduleJob(this.JOB_ID);
            }
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new SchedulerServiceException(e.getMessage(), (Throwable)e);
        }
        finally {
            this.nextRunDate = null;
            this.JOB_ID = null;
        }
    }

    @Override
    public JobDetails getJobDetails() {
        if (this.JOB_ID != null) {
            return this.confluenceSchedulerService.getJobDetails(this.JOB_ID);
        }
        return null;
    }

    @Override
    public Date getNextRunDate() {
        return this.nextRunDate;
    }

    @Override
    public List<JobDetails> getJobsByJobRunnerKey() {
        return this.confluenceSchedulerService.getJobsByJobRunnerKey(this.JOB_RUNNER_KEY);
    }

    @Override
    public RunDetails getLastRunForJob() {
        return this.runDetailsDao.getLastRunForJob(this.JOB_ID);
    }

    @Override
    public RunDetails getLastSuccessfulRunForJob() {
        return this.runDetailsDao.getLastSuccessfulRunForJob(this.JOB_ID);
    }

    @Override
    public boolean isWorking() {
        return this.JOB_ID != null;
    }

    private void doProcessingJob(Map<String, Serializable> parameters) {
        if (this.job != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ProcessingJob parameters ");
                for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
                    LOG.debug("key: " + parameter.getKey() + " = " + parameter.getValue());
                }
            }
            this.job.setHelperService(this.helperService);
            this.job.doProcessingJob(parameters);
            Schedule schedule = this.confluenceSchedulerService.getJobDetails(this.JOB_ID).getSchedule();
            if (schedule != null) {
                long timeInSecs = System.currentTimeMillis();
                this.nextRunDate = new Date(timeInSecs + schedule.getIntervalScheduleInfo().getIntervalInMillis());
                LOG.warn("nextRunDate= " + this.nextRunDate);
            }
        } else {
            LOG.warn("ProcessingJob NO JOB");
        }
    }

    private Date createFirstRunDate(long repeatInterval, int hour) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) >= hour) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis);
    }
}

