/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.user.EntityException;
import de.accxia.apps.confluence.ium.impl.CurrentUser;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.Quota;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/apps")
@Named
public class IUMRest {
    private static final Logger LOG = LoggerFactory.getLogger(IUMRest.class);
    @ComponentImport
    private final UserAccessor userAccessor;
    private final IUMHelperService helperService;

    @Inject
    public IUMRest(UserAccessor userAccessor, IUMHelperService helperService) {
        this.userAccessor = userAccessor;
        this.helperService = helperService;
    }

    @Path(value="/retry")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response attemptToEnableUser(@Context HttpServletRequest request) {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        CurrentUser currentUser = this.helperService.enableUserFromGroup(user, request);
        boolean message = currentUser != null;
        return Response.ok((Object)("{\"warningMessage\":\"" + message + "\"}")).build();
    }

    @Path(value="/check")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response checkCanGetFreeSlots(@QueryParam(value="username") String username) {
        try {
            Quota retVal = this.helperService.checkCanGetFreeSlots(username);
            return Response.ok((Object)retVal).build();
        }
        catch (EntityException e) {
            LOG.error("EntityException " + e.getMessage(), (Throwable)e);
            return Response.ok((Object)Quota.Empty).build();
        }
    }
}

