/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewed;
import com.atlassian.confluence.plugins.recentlyviewed.RecentlyViewedManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/test")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class TestServlet {
    private static final Logger LOG = LoggerFactory.getLogger(TestServlet.class);
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final GroupManager groupManager;
    @ComponentImport
    private final RecentlyViewedManager recentlyViewedManager;
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Inject
    public TestServlet(GroupManager groupManager, UserManager userManager, UserAccessor userAccessor, RecentlyViewedManager recentlyViewedManager) {
        this.groupManager = groupManager;
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.recentlyViewedManager = recentlyViewedManager;
    }

    @Path(value="/view")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getUserAction4Group(@QueryParam(value="group") String groupName) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Group group = this.groupManager.getGroup(groupName);
            Iterable users = this.userAccessor.getMembers(group);
            for (ConfluenceUser user : users) {
                if (this.userManager.isAdmin(user.getKey())) continue;
                List recent = this.recentlyViewedManager.getRecentlyViewed(user.getKey(), true, 1);
                long lastViewed = 0L;
                if (recent.size() > 0) {
                    lastViewed = ((RecentlyViewed)recent.get(0)).getLastSeen();
                }
                map.put(user.getName(), lastViewed != 0L ? SDF.format(new Date(lastViewed)) : "Never");
            }
            return Response.ok(map).build();
        }
        catch (Exception e) {
            LOG.error("Exception" + e.getMessage(), (Throwable)e);
            return Response.ok(map).build();
        }
    }
}

