/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMClusterJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMClusterJob instance;
    private IUMHelperService helperService;

    private IUMClusterJob() {
    }

    public static IUMClusterJob getInstance() {
        if (instance == null) {
            instance = new IUMClusterJob();
        }
        return instance;
    }

    @Override
    public void doProcessingJob(Map<String, Serializable> parameters) {
        String enableGroups;
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        if (StringUtils.isEmpty((String)(enableGroups = (String)((Object)parameters.get("enable_groups"))))) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMClusterJob Empty enableGroup --> skip at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            return;
        }
        long refTS = System.currentTimeMillis() - inactivityInterval;
        List<ConfluenceUser> inactiveUsers = this.helperService.getOnlyEnabledUsers(refTS);
        for (ConfluenceUser user : inactiveUsers) {
            this.helperService.removeUserFromGroup(user, enableGroups);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed #[" + SDF.format(new Date()) + "] ");
        }
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    @Override
    public void setHelperService(IUMHelperService helperService) {
        this.helperService = helperService;
    }
}

