/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMFakeJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMFakeJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMFakeJob instance;
    private IUMHelperService helperService;

    private IUMFakeJob() {
    }

    public static IUMFakeJob getInstance() {
        if (instance == null) {
            instance = new IUMFakeJob();
        }
        return instance;
    }

    @Override
    public void doProcessingJob(Map<String, Serializable> parameters) {
        int startingFrom;
        long repeatInterval;
        String enableGroups = (String)((Object)parameters.get("enable_groups"));
        String disableGroups = (String)((Object)parameters.get("disable_groups"));
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        if ((repeatInterval = ((Long)parameters.get("repeat_interval")).longValue()) <= 0L) {
            repeatInterval = 60L;
        }
        if ((startingFrom = ((Integer)parameters.get("starting_from")).intValue()) <= 0) {
            startingFrom = 1;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMFakeJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        this.LOG.warn("IUMFakeJob Process with groups={}/{} interval={} [{} / {}] at [ {} ] ", new Object[]{disableGroups, enableGroups, inactivityInterval, repeatInterval, startingFrom, SDF.format(new Date())});
    }

    @Override
    public void setHelperService(IUMHelperService helperService) {
        this.helperService = helperService;
    }
}

