/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.listener;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostUpdateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentEvent;
import com.atlassian.confluence.event.events.content.comment.CommentRemoveEvent;
import com.atlassian.confluence.event.events.content.comment.CommentUpdateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.mail.notification.NotificationsSender;
import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugin.descriptor.mail.NotificationContext;
import com.atlassian.confluence.plugins.mentions.api.MentionFinder;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DeletedUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.event.Event;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.renderer.RenderContext;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.util.EmailUtil;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.IUMMentionService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class HookListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(HookListener.class);
    public static final String PLUGIN_KEY = "de.accxia.apps.confluence.IUM.IUM4Confluence";
    @ConfluenceImport
    private final LocalNotificationService localNotificationService;
    @ConfluenceImport
    private EventPublisher eventPublisher;
    @ComponentImport
    private final NotificationManager notificationManager;
    @ComponentImport
    private final MentionFinder mentionFinder;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final CrowdService crowdService;
    @ComponentImport
    private final PermissionManager permissionManager;
    private final IUMHelperService helperService;
    private final IUMMentionService iumMentionService;

    @Inject
    public HookListener(EventPublisher eventPublisher, UserAccessor userAccessor, LocalNotificationService localNotificationService, NotificationManager notificationManager, MentionFinder mentionFinder, CrowdService crowdService, PermissionManager permissionManager, IUMHelperService helperService, IUMMentionService iumMentionService) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor);
        this.crowdService = (CrowdService)Preconditions.checkNotNull((Object)crowdService);
        this.notificationManager = (NotificationManager)Preconditions.checkNotNull((Object)notificationManager);
        this.localNotificationService = (LocalNotificationService)Preconditions.checkNotNull((Object)localNotificationService);
        this.permissionManager = (PermissionManager)Preconditions.checkNotNull((Object)permissionManager);
        this.helperService = helperService;
        this.iumMentionService = iumMentionService;
        this.mentionFinder = mentionFinder;
    }

    @EventListener
    public void blogPostEvents(BlogPostCreateEvent event) {
        this.doBlogPostEvents((BlogPostEvent)event, null);
    }

    @EventListener
    public void blogPostEvents(BlogPostUpdateEvent event) {
        this.doBlogPostEvents((BlogPostEvent)event, (ContentEntityObject)event.getOriginalBlogPost());
    }

    @EventListener
    public void blogPostEvents(BlogPostRemoveEvent event) {
        this.doBlogPostEvents((BlogPostEvent)event, null);
    }

    public void doBlogPostEvents(BlogPostEvent event, ContentEntityObject original) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("blogPostEvents " + event.getBlogPost().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        if (!event.isSuppressNotifications()) {
            this.tryToMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
            this.tryToNotifyInAppUser4DisableGroup(disabledUsers, (ContentEvent)event);
            this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        }
    }

    @EventListener
    public void pageEvents(PageCreateEvent event) {
        this.doPageEvents((PageEvent)event, null);
    }

    @EventListener
    public void pageEvents(PageUpdateEvent event) {
        this.doPageEvents((PageEvent)event, (ContentEntityObject)event.getOriginalPage());
    }

    @EventListener
    public void pageEvents(PageRemoveEvent event) {
        this.doPageEvents((PageEvent)event, null);
    }

    private void doPageEvents(PageEvent event, ContentEntityObject original) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("blogPostEvents " + event.getPage().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        if (!event.isSuppressNotifications()) {
            this.tryToMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
            this.tryToNotifyInAppUser4DisableGroup(disabledUsers, (ContentEvent)event);
            this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        }
    }

    @EventListener
    public void commentEvents(CommentCreateEvent event) {
        this.doCommentEvents((CommentEvent)event, null);
    }

    @EventListener
    public void commentEvents(CommentUpdateEvent event) {
        this.doCommentEvents((CommentEvent)event, (ContentEntityObject)event.getOriginalComment());
    }

    @EventListener
    public void commentEvents(CommentRemoveEvent event) {
        this.doCommentEvents((CommentEvent)event, null);
    }

    private void doCommentEvents(CommentEvent event, ContentEntityObject original) {
        if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("blogPostEvents " + event.getComment().getType() + " " + event.toString());
        }
        List<String> disabledUsers = this.helperService.getOnlyDisabledUsers();
        this.tryToMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        this.tryToNotifyInAppUser4DisableGroup(disabledUsers, (ContentEvent)event);
        this.tryToNotifyMailsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        if (event instanceof CommentCreateEvent) {
            this.tryToEmailMentionsUser4DisableGroup(disabledUsers, (ContentEvent)event, original);
        }
    }

    private void tryToMentionsUser4DisableGroup(List<String> disabledUsers, ContentEvent event, ContentEntityObject original) {
        Set mentionedUsernames;
        Set set = mentionedUsernames = original != null ? this.mentionFinder.getNewMentionedUsernames(event.getContent().getBodyContent(), original.getBodyContent()) : this.mentionFinder.getMentionedUsernames(event.getContent().getBodyContent());
        if (mentionedUsernames == null || mentionedUsernames.size() == 0) {
            return;
        }
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        this.permissionManager.withExemption(() -> mentionedUsernames.stream().forEach(userName -> {
            ConfluenceUser mentionedUser = this.userAccessor.getUserByName(userName);
            if (mentionedUser != null && mentionedUser.getName() != null && !this.isDisabled(mentionedUser.getName()) && !DeletedUser.isDeletedUser((User)mentionedUser) && disabledUsers.contains(mentionedUser.getName())) {
                try {
                    this.iumMentionService.sendMentions(mentionedUser, event.getContent());
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        }));
    }

    private void tryToNotifyInAppUser4DisableGroup(List<String> disabledUsers, ContentEvent event) {
        List notificationList = this.notificationManager.getNotificationsByContent(event.getContent());
        if (notificationList == null || notificationList.size() == 0) {
            return;
        }
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        notificationList.stream().forEach(n -> {
            if (disabledUsers.contains(n.getReceiver().getName())) {
                try {
                    com.atlassian.mywork.model.Notification nx = this.createNotification(event);
                    ConfluenceUser notifyUser = n.getReceiver();
                    if (nx != null && notifyUser != null && notifyUser.getName() != null && !this.isDisabled(notifyUser.getName()) && !DeletedUser.isDeletedUser((User)notifyUser)) {
                        this.sendNotification((User)n.getReceiver(), nx);
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    private void tryToEmailMentionsUser4DisableGroup(List<String> disabledUsers, ContentEvent event, ContentEntityObject original) {
        Set mentionedUsernames;
        Set set = mentionedUsernames = original != null ? this.mentionFinder.getNewMentionedUsernames(event.getContent().getBodyContent(), original.getBodyContent()) : this.mentionFinder.getMentionedUsernames(event.getContent().getBodyContent());
        if (mentionedUsernames == null || mentionedUsernames.size() == 0) {
            return;
        }
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        NotificationsSender notificationsSender = (NotificationsSender)ContainerManager.getComponent((String)"notificationsSender");
        PageContext renderContext = original == null ? event.getContent().toPageContext() : original.toPageContext();
        renderContext.setOutputType(ConversionContextOutputType.EMAIL.value());
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)renderContext);
        conversionContext.setProperty("renderForWorkBox", (Object)true);
        String actionDescription = " mentioned you in ";
        Comment comment = (Comment)event.getContent();
        ContentEntityObject page = comment.getContainer();
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        this.permissionManager.withExemption(() -> this.lambda$tryToEmailMentionsUser4DisableGroup$4(mentionedUsernames, disabledUsers, page, original, event, currentUser, actionDescription, comment, notificationsSender, (ConversionContext)conversionContext));
    }

    private boolean isDisabled(String username) {
        com.atlassian.crowd.embedded.api.User user = this.crowdService.getUser(username);
        return user == null || !user.isActive();
    }

    private void sendMailNotification(ConfluenceUser currentUser, ContentEvent event, ContentEntityObject original, String title, Notification notif, NotificationsSender notificationsSender, ConversionContext conversionContext) {
        try {
            NotificationData notificationData = this.getNotificationDataForEvent((Event)event, (User)currentUser, (ConfluenceEntityObject)original);
            notificationData.setSubject(title);
            if (event instanceof CommentEvent) {
                if (event instanceof CommentCreateEvent) {
                    notificationData.setTemplateName("comment-added-notification.vm");
                    notificationData.addToContext("contentType", (Serializable)((Object)"comment"));
                    notificationData.addToContext("page.type", (Serializable)((Object)"comment"));
                    notificationData.addToContext("comment.id", (Serializable)Long.valueOf(event.getContent().getId()));
                    notificationData.addToContext("comment", (Serializable)event.getContent());
                    notificationData.addToContext("page", ((CommentEvent)event).getComment().getContainer() instanceof Page ? (Page)((CommentEvent)event).getComment().getContainer() : null);
                }
            } else {
                notificationData.setTemplateName("page-edited-notification.vm");
                notificationData.addToContext("contentType", (Serializable)((Object)"page"));
                notificationData.addToContext("page.id", (Serializable)Long.valueOf(event.getContent().getId()));
                notificationData.addToContext("page", (Serializable)event.getContent());
            }
            if (notificationData.getCommonContext().getContent() == null) {
                LOG.info("Find notificationData.getCommonContext().getContent()==null ");
                notificationData.addToContext("content", (Serializable)event.getContent());
            }
            notificationData.addToContext("originalContent", (Serializable)original);
            this.setPermissionEntity(notificationData);
            notificationsSender.sendNotification(notif, notificationData, conversionContext);
            if (LOG.isInfoEnabled()) {
                LOG.info("Mail Notification send from " + currentUser.getName() + " to " + (notif.getReceiver() != null ? notif.getReceiver().getName() : "N/A") + " with email=" + (notif.getReceiver() != null ? notif.getReceiver().getEmail() : "N/A"));
            }
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    private void tryToNotifyMailsUser4DisableGroup(List<String> disabledUsers, ContentEvent event, ContentEntityObject original) {
        if (disabledUsers == null || disabledUsers.size() == 0) {
            return;
        }
        if (EmailUtil.checkMailServer()) {
            List notificationList = this.notificationManager.getNotificationsByContent(event.getContent());
            ArrayList notificationPageList = new ArrayList();
            if (event instanceof PageEvent) {
                notificationPageList.addAll(this.notificationManager.getNotificationsBySpaceAndType(((PageEvent)event).getPage().getSpace(), null));
            }
            if (event instanceof CommentEvent) {
                notificationPageList.addAll(this.notificationManager.getNotificationsBySpaceAndType(((CommentEvent)event).getComment().getSpace(), null));
            }
            if (event instanceof BlogPostEvent) {
                notificationPageList.addAll(this.notificationManager.getNotificationsBySpaceAndType(((BlogPostEvent)event).getBlogPost().getSpace(), null));
            }
            ArrayList<String> remainingDisabledUsers = new ArrayList<String>(disabledUsers);
            ArrayList remainingNotificationList = new ArrayList();
            notificationList.stream().forEach(notif -> {
                if (disabledUsers.contains(notif.getReceiver().getName())) {
                    remainingNotificationList.add(notif);
                    remainingDisabledUsers.remove(notif.getReceiver().getName());
                }
            });
            notificationPageList.stream().forEach(notif -> {
                if (disabledUsers.contains(notif.getReceiver().getName())) {
                    remainingNotificationList.add(notif);
                    remainingDisabledUsers.remove(notif.getReceiver().getName());
                }
            });
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            if (remainingNotificationList != null && remainingNotificationList.size() > 0) {
                NotificationsSender notificationsSender = (NotificationsSender)ContainerManager.getComponent((String)"notificationsSender");
                PageContext renderContext = original == null ? event.getContent().toPageContext() : original.toPageContext();
                DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)renderContext);
                String title = this.buildTitle(event, original);
                try {
                    this.permissionManager.withExemption(() -> this.lambda$tryToNotifyMailsUser4DisableGroup$8(remainingNotificationList, currentUser, event, original, title, notificationsSender, (ConversionContext)conversionContext));
                }
                catch (Exception e) {
                    LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void setPermissionEntity(NotificationData notificationData) {
        try {
            Field field = notificationData.getClass().getDeclaredField("permissionEntity");
            field.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(notificationData, null);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private NotificationData getNotificationDataForEvent(Event event, User user, ConfluenceEntityObject entity) {
        NotificationData notificationData = new NotificationData(user, true, entity);
        NotificationContext commonContext = notificationData.getCommonContext();
        if (event instanceof ContentEvent) {
            commonContext.setContent((ConfluenceEntityObject)((ContentEvent)event).getContent());
        }
        commonContext.setEvent(event);
        return notificationData;
    }

    private String buildTitle(ContentEvent event, ContentEntityObject original) {
        String title = event.getContent().getDisplayTitle();
        if (event instanceof PageEvent) {
            title = ((PageEvent)event).getPage().getSpace().getDisplayTitle() + " > " + title;
        } else if (event instanceof BlogPostEvent) {
            title = ((BlogPostEvent)event).getBlogPost().getSpace().getDisplayTitle() + " > " + title;
        }
        return title;
    }

    private com.atlassian.mywork.model.Notification createNotification(ContentEvent event) {
        NotificationBuilder notificationBuilder = new NotificationBuilder().application(PLUGIN_KEY).groupingId(PLUGIN_KEY);
        if (event instanceof CommentEvent) {
            CommentEvent commentEvent = (CommentEvent)event;
            notificationBuilder.title(commentEvent.getComment().getDisplayTitle()).itemTitle(commentEvent.getComment().getContainer().getTitle()).description(commentEvent.getComment().getBodyAsString());
        } else if (event instanceof PageEvent) {
            PageEvent pageEvent = (PageEvent)event;
            notificationBuilder.title(pageEvent.getPage().getTitle()).itemTitle(pageEvent.getPage().getDisplayTitle()).description(pageEvent.getPage().getBodyAsString());
        } else if (event instanceof BlogPostEvent) {
            BlogPostEvent blogPostEvent = (BlogPostEvent)event;
            notificationBuilder.title(blogPostEvent.getBlogPost().getDisplayTitle()).itemTitle(blogPostEvent.getBlogPost().getTitle()).description(blogPostEvent.getBlogPost().getBodyAsString());
        } else {
            return null;
        }
        return notificationBuilder.createNotification();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    private com.atlassian.mywork.model.Notification sendNotification(User user, com.atlassian.mywork.model.Notification notification) throws InterruptedException, ExecutionException {
        return (com.atlassian.mywork.model.Notification)this.localNotificationService.createOrUpdate(user.getName(), notification).get();
    }

    private static String getContentTypeDescription(ContentEntityObject content) {
        String contentTypeDescription;
        switch (content.getTypeEnum()) {
            default: {
                contentTypeDescription = "a page";
                break;
            }
            case COMMENT: {
                contentTypeDescription = "a comment";
                break;
            }
            case BLOG: {
                contentTypeDescription = "a blog post";
            }
        }
        return contentTypeDescription;
    }

    private /* synthetic */ void lambda$tryToNotifyMailsUser4DisableGroup$8(List remainingNotificationList, ConfluenceUser currentUser, ContentEvent event, ContentEntityObject original, String title, NotificationsSender notificationsSender, ConversionContext conversionContext) {
        remainingNotificationList.stream().forEach(notif -> this.sendMailNotification(currentUser, event, original, title, (Notification)notif, notificationsSender, conversionContext));
    }

    private /* synthetic */ void lambda$tryToEmailMentionsUser4DisableGroup$4(Set mentionedUsernames, List disabledUsers, ContentEntityObject page, ContentEntityObject original, ContentEvent event, ConfluenceUser currentUser, String actionDescription, Comment comment, NotificationsSender notificationsSender, ConversionContext conversionContext) {
        mentionedUsernames.stream().forEach(userName -> {
            try {
                ConfluenceUser toUser = this.userAccessor.getUserByName(userName);
                if (toUser != null && toUser.getName() != null && !DeletedUser.isDeletedUser((User)toUser) && !this.isDisabled(toUser.getName()) && disabledUsers.contains(userName)) {
                    Notification notification = this.notificationManager.getNotificationByUserAndContent((User)toUser, page);
                    if (notification == null) {
                        notification = this.notificationManager.addContentNotification((User)toUser, original == null ? event.getContent() : original);
                    }
                    if (notification != null) {
                        NotificationData notificationData = this.getNotificationDataForEvent((Event)event, (User)currentUser, (ConfluenceEntityObject)original);
                        String fullName = currentUser != null ? currentUser.getFullName() : "Anonymous";
                        notificationData.setSubject(fullName + actionDescription + "\"" + page.getTitle() + "\"");
                        notificationData.setTemplateName("comment-added-notification.vm");
                        notificationData.addToContext("contentType", (Serializable)((Object)"comment"));
                        notificationData.addToContext("comment.id", (Serializable)Long.valueOf(event.getContent().getId()));
                        notificationData.addToContext("comment", (Serializable)event.getContent());
                        notificationData.addToContext("originalContent", (Serializable)(original == null ? event.getContent() : new Comment()));
                        notificationData.addToContext("page", (Serializable)page);
                        notificationData.addToContext("url", (Serializable)((Object)comment.getUrlPath()));
                        this.setPermissionEntity(notificationData);
                        notificationsSender.sendNotification(notification, notificationData, conversionContext);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Mail Notification send " + toUser.getName() + " " + (notification.getReceiver() != null ? notification.getReceiver().getName() : "N/A") + " with email=" + (notification.getReceiver() != null ? notification.getReceiver().getEmail() : "N/A"));
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Exception " + e.getMessage(), (Throwable)e);
            }
        });
    }
}

