/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.util;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailUtil {
    private static final Logger log = LoggerFactory.getLogger(EmailUtil.class);

    public static void sendMail(String to, String subject, String body, Boolean isSupportsHTML) throws MailException {
        if (log.isDebugEnabled()) {
            log.debug("SendMail to {} \n subject {} ", new Object[]{to, subject});
        }
        Email email = new Email(to);
        email.setSubject(subject);
        Map context = MacroUtils.defaultVelocityContext();
        context.put("subject", subject);
        context.put("body", body);
        email.setBody(VelocityUtils.getRenderedTemplate((String)"templates/email.vm", (Map)context));
        if (isSupportsHTML.booleanValue()) {
            email.setMimeType("text/html");
        }
        EmailUtil.sendMail(email);
    }

    public static boolean checkMailServer() {
        MailServerManager mailServerManager = (MailServerManager)ComponentLocator.getComponent(MailServerManager.class);
        SMTPMailServer mailServer = mailServerManager.getDefaultSMTPMailServer();
        return !Objects.isNull(mailServer);
    }

    private static void sendMail(Email email) throws MailException {
        MailServerManager mailServerManager = (MailServerManager)ComponentLocator.getComponent(MailServerManager.class);
        SMTPMailServer mailServer = mailServerManager.getDefaultSMTPMailServer();
        if (log.isDebugEnabled()) {
            log.debug("Send email to: " + email.getTo());
        }
        if (Objects.isNull(mailServer)) {
            log.error("SMTP mail server is not found. Please configure new SMTP mail server.");
        } else {
            mailServer.send(email);
        }
    }
}

