/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.job.IUMSyncJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ExportAsService(value={JobSyncService.class})
@Named(value="jobSyncService")
public class JobSyncService {
    private static final Log LOG = LogFactory.getLog(JobSyncService.class);
    private final MonitorJobRunner monitorJobRunner;

    @Inject
    public JobSyncService(MonitorJobRunner monitorJobRunner) {
        this.monitorJobRunner = monitorJobRunner;
    }

    public boolean start() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JobSyncService call start");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            this.monitorJobRunner.doSchedule(JobDataUtils.createIUMSyncJobData(), IUMSyncJob.getInstance());
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error((Object)("Exception" + msg), (Throwable)e);
            return false;
        }
    }

    public boolean stop() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"JobSyncService doStop");
            }
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            return true;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            LOG.error((Object)("Exception" + msg), (Throwable)e);
            return false;
        }
    }

    public boolean isWorking() {
        return this.monitorJobRunner.isWorking(IUMSyncJob.class);
    }

    public JobDetails getJobDetails() {
        return this.monitorJobRunner.getJobDetails(IUMSyncJob.class);
    }

    public Date getNextRunDate() {
        return this.monitorJobRunner.getNextRunDate(IUMSyncJob.class);
    }

    public RunDetails getLastSuccessfulRunForJob() {
        return this.monitorJobRunner.getLastSuccessfulRunForJob(IUMSyncJob.class);
    }
}

