/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import de.accxia.apps.confluence.ium.cache.PropertyCachedManager;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.JobClusterService;
import de.accxia.apps.confluence.ium.job.JobSyncService;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="PropertyCacheEntryAdapter")
public class PropertyCacheEntryAdapter<V>
implements CacheEntryListener<String, V> {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyCachedManager.class);
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;

    @Inject
    public PropertyCacheEntryAdapter(JobClusterService jobClusterService, JobSyncService jobSyncService) {
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
    }

    public void onAdd(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (!(cacheEntryEvent.getKey() instanceof String) || !(cacheEntryEvent.getValue() instanceof String)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onAdd " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void onEvict(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onEvict " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onRemove(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onRemove " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
    }

    public void onUpdate(@Nonnull CacheEntryEvent<String, V> cacheEntryEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("CacheEntryEvent onUpdate " + (String)cacheEntryEvent.getKey() + " old=" + cacheEntryEvent.getOldValue() + " new=" + cacheEntryEvent.getValue());
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("workingJob") && cacheEntryEvent.getValue() instanceof String) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String workingJob = (String)cacheEntryEvent.getValue();
            try {
                if ("on".equalsIgnoreCase(workingJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=ON isWorking=" + this.jobClusterService.isWorking());
                    }
                    if (this.jobClusterService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop JobClusterService " + new Date());
                        this.jobClusterService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start JobClusterService " + new Date());
                    this.jobClusterService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingJob=OFF isWorking=" + this.jobClusterService.isWorking());
                    }
                    if (this.jobClusterService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop JobClusterService " + new Date());
                        this.jobClusterService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("workingSyncJob") && cacheEntryEvent.getValue() instanceof String) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String workingSyncJob = (String)cacheEntryEvent.getValue();
            try {
                if ("on".equalsIgnoreCase(workingSyncJob)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob=ON isWorking=" + this.jobSyncService.isWorking());
                    }
                    if (this.jobSyncService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobSyncService " + new Date());
                        this.jobSyncService.stop();
                    }
                    LOG.warn("[PropertyCacheEntryAdapter] Start jobSyncService " + new Date());
                    this.jobSyncService.start();
                } else {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[PropertyCacheEntryAdapter] receive workingSyncJob=OFF isWorking=" + this.jobSyncService.isWorking());
                    }
                    if (this.jobSyncService.isWorking()) {
                        LOG.info("[PropertyCacheEntryAdapter] Stop jobSyncService " + new Date());
                        this.jobSyncService.stop();
                    }
                }
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
        if (((String)cacheEntryEvent.getKey()).equalsIgnoreCase("sideLicense") && cacheEntryEvent.getValue() instanceof String) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("[PropertyCacheEntryAdapter] receive sideLicense= [" + (String)cacheEntryEvent.getKey() + "] value=" + cacheEntryEvent.getValue());
            }
            String sideLicense = (String)cacheEntryEvent.getValue();
            try {
                DAO.updateSideLicense(sideLicense);
                ConditionEvaluatorIUMImpl.deleteSideLicense();
                ConditionEvaluatorIUMImpl.setSideLicense(sideLicense);
                LOG.warn("[PropertyCacheEntryAdapter] update sideLicense " + new Date());
            }
            catch (Exception ex) {
                LOG.error("Exception " + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

