/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.Group;
import com.google.common.collect.Sets;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMSyncJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMSyncJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMSyncJob instance;
    private IUMHelperService helperService;
    int syncUsers = 0;

    private IUMSyncJob() {
    }

    public static IUMSyncJob getInstance() {
        if (instance == null) {
            instance = new IUMSyncJob();
        }
        return instance;
    }

    @Override
    public void setHelperService(IUMHelperService helperService) {
        this.helperService = helperService;
    }

    @Override
    public void doProcessingJob(Map<String, Serializable> parameters) {
        String sourceGroups = (String)((Object)parameters.get("source_all_groups"));
        String targetGroup = (String)((Object)parameters.get("target_all_group"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.helperService != null) {
            String[] arraySourceGroups = sourceGroups.split(",");
            String[] arrayTargetGroups = targetGroup.split(",");
            this.syncUsers = 0;
            for (int i = 0; i < arraySourceGroups.length; ++i) {
                if (arrayTargetGroups.length <= i || IUMSyncJob.isEmpty(arraySourceGroups[i]) || IUMSyncJob.isEmpty(arrayTargetGroups[i])) continue;
                this.processPair(arraySourceGroups[i], arrayTargetGroups[i]);
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMSyncJob copied #" + this.syncUsers + " to groups " + targetGroup);
            }
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Processed #[" + SDF.format(new Date()) + "] ");
        }
    }

    private void processPair(String sourceGroups, String targetGroup) {
        String[] arrayEnableGroups;
        String[] stringArray = arrayEnableGroups = IUMSyncJob.isEmpty(sourceGroups) ? null : sourceGroups.split(";");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (arrayEnableGroups != null && arrayEnableGroups.length > 0 && targetGroup != null && targetGroup.length() > 0) {
            List<ConfluenceUser> targetUsers;
            Group confluenceTargetGroup;
            try {
                confluenceTargetGroup = this.helperService.getGroupByName(targetGroup);
                targetUsers = this.helperService.getUsersFromGroup(confluenceTargetGroup);
            }
            catch (Exception ex) {
                this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                return;
            }
            ArrayList<ConfluenceUser> sourceUsers = new ArrayList<ConfluenceUser>();
            for (String group : arrayEnableGroups) {
                try {
                    sourceUsers.addAll(this.helperService.getUsersFromGroup(group));
                }
                catch (Exception ex) {
                    this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                }
            }
            Set targetUserSet = targetUsers.stream().collect(Collectors.toSet());
            Set sourceUserSet = sourceUsers.stream().collect(Collectors.toSet());
            Sets.SetView set2AddView = Sets.difference(sourceUserSet, targetUserSet);
            Sets.SetView set2RemoveView = Sets.difference(targetUserSet, sourceUserSet);
            set2AddView.stream().forEach(user -> {
                try {
                    this.helperService.addUserToGroup((ConfluenceUser)user, confluenceTargetGroup);
                    ++this.syncUsers;
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info("IUMSyncJob added user {} to group   {} ", new Object[]{user.getName(), targetGroup});
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            });
            set2RemoveView.stream().forEach(user -> {
                try {
                    this.helperService.removeUserFromGroup((ConfluenceUser)user, confluenceTargetGroup);
                    ++this.syncUsers;
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info("IUMSyncJob added user {} to group   {} ", new Object[]{user.getName(), targetGroup});
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            });
        } else {
            this.LOG.warn("IUMSyncJob skipped Empty Source/Target config");
        }
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

