/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet;

import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.user.User;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import de.accxia.apps.confluence.ium.conditions.ConditionEvaluatorIUMImpl;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.config.RestRoute;
import de.accxia.apps.confluence.ium.job.JobClusterService;
import de.accxia.apps.confluence.ium.job.JobSyncService;
import de.accxia.apps.confluence.ium.job.RunDetailsBean;
import de.accxia.apps.confluence.ium.util.IUMGroup;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class AdminServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(AdminServlet.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long serialVersionUID = -5924742251376879902L;
    @ComponentImport
    private final UserManager userManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final TemplateRenderer renderer;
    @ComponentImport
    private final LoginUriProvider loginUriProvider;
    @ComponentImport
    private final WebSudoManager webSudoManager;
    @ComponentImport
    private final LocaleManager localeManager;
    @ComponentImport
    private final I18NBeanFactory i18NBeanFactory;
    @ComponentImport
    private final LicenseService licenseService;
    @ComponentImport
    private final ApplicationProperties applicationProperties;
    private final IUMHelperService helperService;
    private final JobClusterService jobClusterService;
    private final JobSyncService jobSyncService;

    @Inject
    public AdminServlet(JobClusterService jobClusterService, JobSyncService jobSyncService, UserManager userManager, UserAccessor userAccessor, TemplateRenderer renderer, LoginUriProvider loginUriProvider, WebSudoManager webSudoManager, LocaleManager localeManager, I18NBeanFactory i18NBeanFactory, LicenseService licenseService, ApplicationProperties applicationProperties, IUMHelperService helperService) {
        this.jobClusterService = jobClusterService;
        this.jobSyncService = jobSyncService;
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.userAccessor = (UserAccessor)Preconditions.checkNotNull((Object)userAccessor);
        this.renderer = (TemplateRenderer)Preconditions.checkNotNull((Object)renderer);
        this.loginUriProvider = (LoginUriProvider)Preconditions.checkNotNull((Object)loginUriProvider);
        this.webSudoManager = webSudoManager;
        this.localeManager = localeManager;
        this.i18NBeanFactory = i18NBeanFactory;
        this.licenseService = licenseService;
        this.helperService = helperService;
        this.applicationProperties = applicationProperties;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            UserProfile theUser = this.userManager.getRemoteUser(request);
            if (theUser == null || !this.userManager.isAdmin(theUser.getUserKey())) {
                this.redirectToLogin(request, response);
                return;
            }
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String pageId = request.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                try {
                    String sideLicense = request.getParameter("sideLicense");
                    if (sideLicense == null || "".equals(sideLicense)) {
                        ConditionEvaluatorIUMImpl.deleteSideLicense();
                    }
                    DAO.updateSideLicense(sideLicense);
                    ConditionEvaluatorIUMImpl.setSideLicense();
                    this.renderSideLicenseVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.license"), null);
                }
                catch (Exception e) {
                    LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                    this.renderSideLicenseVM(response, null, e.getMessage());
                }
                return;
            }
            boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            String action = request.getParameter("action");
            if ("remove".equals(action)) {
                String successMessage = this.helperService.disabelAllUsersFromTheEnabledGroups(request.getParameter("groupName"));
                this.renderAdminVM(response, successMessage, null, Page.PageUserManagement, showSideLicense);
                return;
            }
            switch (page) {
                case PageSAMLSSO: {
                    try {
                        String samlIdp = "";
                        if (request.getParameter("samlIdp") != null) {
                            samlIdp = request.getParameter("samlIdp");
                        }
                        DAO.updateSamlIdp(samlIdp);
                        String samlMapping = "saml2:nameId";
                        if (request.getParameter("samlMapping") != null) {
                            samlMapping = request.getParameter("samlMapping");
                        }
                        DAO.updateSamlMapping(samlMapping);
                        String samlRegex = "";
                        if (request.getParameter("samlRegex") != null) {
                            samlRegex = request.getParameter("samlRegex");
                        }
                        DAO.updateSamlRegex(samlRegex);
                        this.renderSamlVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.saml"), null);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderSamlVM(response, null, e.getMessage());
                    }
                    return;
                }
                case PageGroupSettings: {
                    try {
                        if (request.getParameterValues("IUMGroupSoftware") != null && request.getParameterValues("IUMGroupDisableSoftware") != null && request.getParameterValues("queueSizeSoftware") != null) {
                            List enableGroups = Arrays.stream(request.getParameterValues("IUMGroupSoftware")).distinct().collect(Collectors.toList());
                            List disableGroups = Arrays.stream(request.getParameterValues("IUMGroupDisableSoftware")).distinct().collect(Collectors.toList());
                            List queueSize = Arrays.stream(request.getParameterValues("queueSizeSoftware")).collect(Collectors.toList());
                            if (enableGroups.size() == disableGroups.size() && enableGroups.size() == queueSize.size()) {
                                String reportGroups = String.join((CharSequence)",", enableGroups);
                                DAO.updateIUMGroup(reportGroups);
                                String reportGroupsDIS = String.join((CharSequence)",", disableGroups);
                                DAO.updateIUMGroupDisabled(reportGroupsDIS);
                                DAO.updateQueueSize(String.join((CharSequence)",", queueSize));
                                String duration = "1";
                                if (request.getParameterValues("duration") != null) {
                                    duration = String.join((CharSequence)",", request.getParameterValues("duration"));
                                    DAO.updateDuration(duration);
                                }
                                this.patchGroupsForSyncJob(reportGroupsDIS);
                                this.renderAdminVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.group"), null, page, showSideLicense);
                                return;
                            }
                        }
                        throw new Exception(" Invalid Parameters Error");
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                        return;
                    }
                }
                case PageRest: {
                    try {
                        String urlRest = request.getParameter("urlRest");
                        DAO.updateUrlRest(urlRest);
                        RestRoute.getInstance().updateRestRoute(urlRest);
                        this.renderAdminVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.rest"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageJob: {
                    try {
                        String workingJob;
                        String startingFrom;
                        String inactivityDuration;
                        boolean shouldRestart = false;
                        String repeatInterval = request.getParameter("repeatInterval");
                        if (repeatInterval != null && !repeatInterval.equalsIgnoreCase(DAO.getRepeatInterval())) {
                            try {
                                Long.parseLong(repeatInterval);
                                DAO.updateRepeatInterval(repeatInterval);
                            }
                            catch (Exception e) {
                                repeatInterval = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((inactivityDuration = request.getParameter("inactivityDuration")) != null && repeatInterval != null && !inactivityDuration.equalsIgnoreCase(DAO.getInactivityDuration())) {
                            try {
                                Long.parseLong(inactivityDuration);
                                DAO.updateInactivityDuration(inactivityDuration);
                            }
                            catch (Exception e) {
                                inactivityDuration = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((startingFrom = request.getParameter("startingFrom")) != null && !startingFrom.equalsIgnoreCase(DAO.getStartingFrom())) {
                            try {
                                Long.parseLong(startingFrom);
                                DAO.updateStartingFrom(startingFrom);
                            }
                            catch (Exception e) {
                                startingFrom = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((workingJob = request.getParameter("workingJob")) != null && "on".equalsIgnoreCase(workingJob)) {
                            DAO.updateWorkingJob(workingJob);
                            if (shouldRestart || !this.jobClusterService.isWorking()) {
                                LOG.warn("Start JobClusterService " + new Date());
                                this.jobClusterService.start();
                            }
                        } else if (workingJob == null || "off".equalsIgnoreCase(workingJob)) {
                            DAO.updateWorkingJob("off");
                            if (this.jobClusterService.isWorking()) {
                                LOG.warn("Stop JobClusterService " + new Date());
                                this.jobClusterService.stop();
                            }
                        }
                        this.renderAdminVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.job"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageSync: {
                    try {
                        String workingJob;
                        String startingFrom;
                        String repeatInterval;
                        boolean shouldRestart = false;
                        if (request.getParameterValues("syncAllSrcGroup-groups") != null && request.getParameterValues("syncAllTargetGroup-groups") != null) {
                            List sourceGroups = Arrays.stream(request.getParameterValues("syncAllSrcGroup-groups")).distinct().collect(Collectors.toList());
                            List targetGroups = Arrays.stream(request.getParameterValues("syncAllTargetGroup-groups")).distinct().collect(Collectors.toList());
                            if (sourceGroups.size() == targetGroups.size()) {
                                String syncSoftwareSrcGroup = String.join((CharSequence)",", sourceGroups);
                                if (syncSoftwareSrcGroup != null && !syncSoftwareSrcGroup.equals(DAO.getSyncAllSrcGoups())) {
                                    shouldRestart = true;
                                }
                                DAO.updateSyncAllSrcGoups(syncSoftwareSrcGroup);
                                String syncSoftwareTargetGroup = String.join((CharSequence)",", targetGroups);
                                if (syncSoftwareTargetGroup != null && !syncSoftwareTargetGroup.equals(DAO.getSyncAllTargetGoups())) {
                                    shouldRestart = true;
                                }
                                DAO.updateSyncAllTargetGoups(syncSoftwareTargetGroup);
                            }
                        }
                        if ((repeatInterval = request.getParameter("syncRepeatInterval")) != null && !repeatInterval.equalsIgnoreCase(DAO.getSyncRepeatInterval())) {
                            try {
                                Long.parseLong(repeatInterval);
                                DAO.updateSyncRepeatInterval(repeatInterval);
                            }
                            catch (Exception e) {
                                repeatInterval = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((startingFrom = request.getParameter("syncStartingFrom")) != null && !startingFrom.equalsIgnoreCase(DAO.getSyncStartingFrom())) {
                            try {
                                Long.parseLong(startingFrom);
                                DAO.updateSyncStartingFrom(startingFrom);
                            }
                            catch (Exception e) {
                                startingFrom = null;
                                LOG.error("Exception " + e.getMessage(), (Throwable)e);
                            }
                            shouldRestart = true;
                        }
                        if ((workingJob = request.getParameter("workingSyncJob")) != null && "on".equalsIgnoreCase(workingJob)) {
                            DAO.updateSyncWorkingJob(workingJob);
                            if (shouldRestart || !this.jobSyncService.isWorking()) {
                                LOG.warn("Start JobClusterService " + new Date());
                                this.jobSyncService.start();
                            }
                        } else if (workingJob == null || "off".equalsIgnoreCase(workingJob)) {
                            DAO.updateSyncWorkingJob("off");
                            if (this.jobSyncService.isWorking()) {
                                LOG.warn("Stop JobClusterService " + new Date());
                                this.jobSyncService.stop();
                            }
                        }
                        this.renderAdminVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.sync"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
                case PageDesign: {
                    try {
                        String urlLogo = request.getParameter("urlLogo");
                        DAO.updateUrlLogo(urlLogo);
                        String queueMessage = request.getParameter("queueMessage");
                        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queueMessage)) {
                            queueMessage = this.i18nBean().getText("IUM-queueMessage.default");
                        }
                        DAO.updateQueueMessage(queueMessage);
                        this.renderAdminVM(response, this.i18nBean().getText("de.accxia.apps.confluence.IUM.save.design"), null, page, showSideLicense);
                    }
                    catch (Exception e) {
                        LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                        this.renderAdminVM(response, null, e.getMessage(), page, showSideLicense);
                    }
                    return;
                }
            }
            this.renderAdminVM(response, null, null, page, showSideLicense);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean showSideLicense;
            UserKey userKey = this.userManager.getRemoteUserKey();
            if (userKey == null || !this.userManager.isAdmin(userKey)) {
                this.redirectToLogin(request, response);
                return;
            }
            this.webSudoManager.willExecuteWebSudoRequest(request);
            String pageId = request.getParameter("page");
            Page page = Page.getPage(pageId);
            if (page == Page.PageLicense) {
                this.renderSideLicenseVM(response, null, null);
                return;
            }
            boolean bl = showSideLicense = !"".equals(DAO.getSideLicense());
            if (!ConditionEvaluatorIUMImpl.isLicenseValid()) {
                this.renderLicenseErrorVM(response, showSideLicense);
                return;
            }
            switch (page) {
                case PageGroupSettings: 
                case PageLicense: {
                    this.renderAdminVM(response, null, null, page, showSideLicense);
                    return;
                }
                case PageSAMLSSO: {
                    this.renderSamlVM(response, null, null);
                    return;
                }
            }
            this.renderAdminVM(response, null, null, page, showSideLicense);
        }
        catch (WebSudoSessionException wes) {
            LOG.error("Exception:" + wes.getMessage(), (Throwable)wes);
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }

    public String getSideLicense() {
        String sideLicense = DAO.getSideLicense();
        return sideLicense;
    }

    private void renderSamlVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("samlIdp", DAO.getSamlIdp());
        context.put("samlMapping", DAO.getSamlMapping());
        context.put("samlRegex", DAO.getSamlRegex());
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/SAML_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderSideLicenseVM(HttpServletResponse response, String successMessage, String errorMessages) throws IOException {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("sideLicense", this.getSideLicense());
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/sidelicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private void renderAdminVM(HttpServletResponse response, String successMessage, String errorMessages, Page page, boolean showSideLicense) throws IOException {
        String queueMessage;
        String urlLogo;
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("successMessage", successMessage);
        context.put("errorMessages", errorMessages);
        context.put("showSideLicense", showSideLicense);
        if (page == Page.PageGroupSettings) {
            this.addGroupSettings(context);
        }
        if (page == Page.PageDesign) {
            urlLogo = DAO.getValueByKey("urlLogo");
            queueMessage = DAO.getValueByKey("queueMessage");
            context.put("urlLogo", urlLogo.isEmpty() ? "" : urlLogo);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queueMessage)) {
                queueMessage = this.i18nBean().getText("IUM-queueMessage.default");
                DAO.updateQueueMessage(queueMessage);
            }
            context.put("queueMessage", queueMessage);
        }
        if (ConditionEvaluatorIUMImpl.getSideLicense() != null) {
            context.put("enhanced", ConditionEvaluatorIUMImpl.getSideLicense().getAppKey().contains("Enhanced"));
        }
        if (page == Page.PageDesign) {
            urlLogo = DAO.getValueByKey("urlLogo");
            queueMessage = DAO.getValueByKey("queueMessage");
            context.put("urlLogo", urlLogo.isEmpty() ? "" : urlLogo);
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)queueMessage)) {
                queueMessage = this.i18nBean().getText("IUM-queueMessage.default");
                queueMessage = this.setValue("queueMessage", queueMessage);
            }
            context.put("queueMessage", queueMessage);
        }
        if (page == Page.PageRest) {
            String urlRest = DAO.getValueByKey("urlRest");
            if (!urlRest.isEmpty()) {
                urlRest = RestRoute.removeDefaultRoute(urlRest);
            }
            context.put("urlRest", urlRest.isEmpty() ? "" : urlRest);
        }
        if (page == Page.PageJob) {
            context.put("repeatInterval", DAO.getRepeatInterval());
            context.put("inactivityDuration", DAO.getInactivityDuration());
            context.put("startingFrom", DAO.getStartingFrom());
            context.put("serverTime", SDF.format(new Date()));
            context.put("workingJob", this.jobClusterService.isWorking());
            if (this.jobClusterService.getNextRunDate() != null) {
                context.put("nextRunDate", SDF.format(this.jobClusterService.getNextRunDate()));
            }
        }
        if (page == Page.PageSync) {
            context.put("syncRepeatInterval", DAO.getSyncRepeatInterval());
            context.put("syncStartingFrom", DAO.getSyncStartingFrom());
            context.put("duration", DAO.getDuration());
            context.put("hasConfluence", true);
            context.put("maxRules", DAO.getIUMGroups() != null ? DAO.getIUMGroups().split(",").length : 1);
            context.put("serverTime", SDF.format(new Date()));
            context.put("workingSyncJob", this.jobSyncService.isWorking());
            if (this.jobSyncService.getNextRunDate() != null) {
                context.put("nextRunDate", SDF.format(this.jobSyncService.getNextRunDate()));
            }
            if (this.jobSyncService.getLastSuccessfulRunForJob() != null) {
                context.put("runDetails", new RunDetailsBean(this.jobSyncService.getLastSuccessfulRunForJob()));
                context.put("lastSuccessfulRunDate", SDF.format(this.jobSyncService.getLastSuccessfulRunForJob().getStartTime()));
            }
            this.addSyncGroups(context);
        }
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/" + page.pageName, context, (Writer)response.getWriter());
    }

    private void addGroupSettings(Map<String, Object> context) {
        String duration;
        ArrayList<IUMGroup> groupPairs = new ArrayList<IUMGroup>();
        String[] iumEnableGroups = DAO.getIUMGroups().split(",");
        String[] iumDisableGroups = DAO.getIUMGroupsDisabled().split(",");
        String[] iumQueueSize = DAO.getQueueSize().split(",");
        for (int i = 0; i < iumEnableGroups.length; ++i) {
            groupPairs.add(new IUMGroup(iumEnableGroups[i], iumDisableGroups.length > i ? iumDisableGroups[i] : "", iumQueueSize.length > i ? AdminServlet.safeParseInt(iumQueueSize[i], 1) : 0));
        }
        context.put("groupPairs", groupPairs);
        context.put("allGroups", this.helperService.getAllGroups());
        context.put("confluenceGroups", this.helperService.getConfluenceGroups());
        ArrayList nonConfluenceGroups = new ArrayList(CollectionUtils.removeAll(this.helperService.getAllGroups(), this.helperService.getConfluenceGroups()));
        context.put("nonConfluenceGroups", nonConfluenceGroups);
        context.put("licenseConsuming", this.userAccessor.countLicenseConsumingUsers());
        context.put("licenseConsumingPowerUsers", this.helperService.getUsersWithConfluenceAccessOtherIUM().size() + 3);
        if (this.licenseService != null && this.licenseService.retrieve() != null) {
            if (this.licenseService.retrieve().isUnlimitedNumberOfUsers()) {
                context.put("serviceSeats", 50000);
            } else if (this.licenseService.retrieve().getMaximumNumberOfUsers() > 0) {
                context.put("serviceSeats", this.licenseService.retrieve().getMaximumNumberOfUsers());
            } else {
                context.put("serviceSeats", 0);
                context.put("errorMessages", "Error retrieving the number of licenses");
            }
        }
        context.put("duration", (duration = DAO.getDuration()).isEmpty() ? "24" : duration);
    }

    @WebSudoRequired
    private void addSyncGroups(Map<String, Object> context) {
        try {
            ArrayList<IUMGroup> groupPairs = new ArrayList<IUMGroup>();
            String[] syncSoftwareSrcGroups = DAO.getSyncAllSrcGoups().split(",");
            String[] syncSoftwareTargetGroups = DAO.getSyncAllTargetGoups().split(",");
            for (int i = 0; i < syncSoftwareSrcGroups.length; ++i) {
                groupPairs.add(new IUMGroup(syncSoftwareSrcGroups[i], syncSoftwareTargetGroups.length > i ? syncSoftwareTargetGroups[i] : "", 0));
            }
            context.put("groupPairs", groupPairs);
            Set groups = this.helperService.getAllGroups().stream().collect(Collectors.toSet());
            Set confluenceGroups = this.helperService.getConfluenceGroups().stream().collect(Collectors.toSet());
            Sets.SetView difference = Sets.difference(groups, confluenceGroups);
            String wvg = DAO.getIUMGroupsDisabled();
            String[] iumGroupDISs = StringUtils.isEmpty((String)wvg) ? new String[]{} : wvg.split(",", -1);
            context.put("validSyncSrcAllGroups", AdminServlet.convertGroupToString((Set<String>)difference));
            context.put("validSyncTargetAllGroups", wvg);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private static String convertGroupToString(Set<String> groups) {
        if (groups == null) {
            return "";
        }
        String retVal = groups.stream().collect(Collectors.joining(","));
        return retVal;
    }

    private void renderLicenseErrorVM(HttpServletResponse response, boolean showSideLicense) throws IOException {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("showSideLicense", showSideLicense);
        context.put("baseurl", this.applicationProperties.getBaseUrl());
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render("templates/checklicense_IUM.vm", context, (Writer)response.getWriter());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    private I18NBean i18nBean() {
        return this.i18NBeanFactory.getI18NBean(this.localeManager.getLocale((User)AuthenticatedUserThreadLocal.get()));
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private void patchGroupsForSyncJob(String iumDisableGroups) {
        if (iumDisableGroups == null || iumDisableGroups.length() == 1) {
            return;
        }
        boolean shouldRestart = false;
        String[] disableGroups = iumDisableGroups.split(",");
        CharSequence[] syncAllTargetGoups = DAO.getSyncAllTargetGoups() == null ? new String[]{} : DAO.getSyncAllTargetGoups().split(",");
        for (int i = 0; i < syncAllTargetGoups.length; ++i) {
            if (this.containsNonEmptyGroup(disableGroups, syncAllTargetGoups[i])) continue;
            syncAllTargetGoups[i] = "";
            shouldRestart = true;
        }
        if (shouldRestart) {
            DAO.updateSyncAllTargetGoups(String.join((CharSequence)",", syncAllTargetGoups));
            if (this.jobSyncService.isWorking()) {
                this.jobSyncService.start();
            }
        }
    }

    private boolean containsNonEmptyGroup(String[] arrays, String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        for (int i = 0; i < arrays.length; ++i) {
            if (!value.equalsIgnoreCase(arrays[i])) continue;
            return true;
        }
        return false;
    }

    private String setValue(String key, String value) {
        if (value == null) {
            value = "";
        }
        DAO.setValue(key, value);
        return value;
    }

    private static int safeParseInt(String value, int defValue) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            return defValue;
        }
    }

    static enum Page {
        None("", "empty.vm"),
        PageGroupSettings("group", "admin_group_IUM.vm"),
        PageDesign("design", "admin_design_IUM.vm"),
        PageRest("rest", "admin_rest_IUM.vm"),
        PageUserManagement("user", "user_IUM.vm"),
        PageJob("job", "admin_job_IUM.vm"),
        PageSync("sync", "admin_sync_IUM.vm"),
        PageLicense("sl", "sidelicense_IUM.vm"),
        PageSAMLSSO("saml", "SAML_IUM.vm");

        String pageId;
        String pageName;

        private Page(String pageId, String pageName) {
            this.pageId = pageId;
            this.pageName = pageName;
        }

        public static Page getPage(String pageId) {
            if (pageId == null) {
                return PageGroupSettings;
            }
            for (Page p : Page.values()) {
                if (!p.pageId.equals(pageId)) continue;
                return p;
            }
            return None;
        }
    }
}

