/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMSyncJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sjob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobSyncRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobSyncRestController.class);
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;

    @Inject
    public JobSyncRestController(MonitorJobRunner monitorJobRunner, IUMHelperService helperService) {
        this.monitorJobRunner = monitorJobRunner;
        this.helperService = helperService;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("repeat_interval", DAO.getRepeatInterval());
        map.put("starting_from", DAO.getStartingFrom());
        map.put("enable_groups", DAO.getIUMGroups());
        map.put("disable_groups", DAO.getIUMGroupsDisabled());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMSyncJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMSyncJob.class) != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails(IUMSyncJob.class).toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMSyncJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMSyncJob.class)) {
            map.put("lastRunForJob", this.monitorJobRunner.getLastRunForJob(IUMSyncJob.class).toString());
            map.put("lastSuccessfulRunForJob", this.monitorJobRunner.getLastSuccessfulRunForJob(IUMSyncJob.class).toString());
            map.put("NextRunDate", this.monitorJobRunner.getNextRunDate(IUMSyncJob.class).toString());
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateRepeatInterval(repeatinterval);
        DAO.updateStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMSyncJobData(), IUMSyncJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        try {
            long duration = Long.parseLong(DAO.getInactivityDuration()) * 60L * 1000L;
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("source_all_groups", (Serializable)((Object)DAO.getSyncAllSrcGoups()));
            parameters.put("target_all_group", (Serializable)((Object)DAO.getSyncAllTargetGoups()));
            parameters.put("inactivity_interval", Long.valueOf(duration));
            IUMSyncJob.getInstance().setHelperService(this.helperService);
            IUMSyncJob.getInstance().doProcessingJob(parameters);
            String response = "{\"message\":\"success\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }
}

