/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.webresource.condition.SimpleUrlReadingCondition;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.confluence.ium.conditions.IsUserInGroupsCondition;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IsUserInGroupsConditionBase
extends SimpleUrlReadingCondition
implements Condition {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);
    private final UserManager userManager;
    private final UserAccessor userAccessor;

    public IsUserInGroupsConditionBase(UserManager userManager, UserAccessor userAccessor) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
    }

    protected boolean isUserInGroups(String userName, String groupNames) {
        if (groupNames == null || "".equals(groupNames)) {
            return false;
        }
        List groups = this.userAccessor.getGroupNamesForUserName(userName);
        if (groups != null) {
            for (String g2 : groupNames.split(",")) {
                if (!groups.contains(g2.trim())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("IsUserInGroupsConditionBase user " + userName + " is in groups=" + groupNames);
                }
                return true;
            }
        }
        return false;
    }

    protected String queryKey() {
        return "IUMDisable";
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        return this.isConditionTrue();
    }
}

