/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.user.Group;
import com.google.common.collect.Sets;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMSyncJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMSyncJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMSyncJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private DisabledUserManager disabledUserManager;
    int syncUsers = 0;

    private IUMSyncJob() {
    }

    public static IUMSyncJob getInstance() {
        if (instance == null) {
            instance = new IUMSyncJob();
        }
        return instance;
    }

    @Override
    public void injectService(IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMSyncJob.instance.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(DisabledUserManager disabledUserManager) {
        this.disabledUserManager = disabledUserManager;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = (String)((Object)parameters.get("source_all_groups"));
        String targetGroup = (String)((Object)parameters.get("target_all_group"));
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.helperService != null) {
            String[] arraySourceGroups = sourceGroups.split(",");
            String[] arrayTargetGroups = targetGroup.split(",");
            Set<ConfluenceUser> confluenceUserAccess = this.helperService.getUsersWithConfluenceUserAccess();
            this.syncUsers = 0;
            for (int i = 0; i < arraySourceGroups.length; ++i) {
                if (arrayTargetGroups.length <= i || IUMSyncJob.isEmpty(arraySourceGroups[i]) || IUMSyncJob.isEmpty(arrayTargetGroups[i])) continue;
                ProcessResult processResult = this.processPair(arraySourceGroups[i], arrayTargetGroups[i], confluenceUserAccess);
                processResultList.add(processResult);
                if (!this.LOG.isDebugEnabled()) continue;
                this.LOG.debug("IUMSyncJob copied #" + processResult.getUserCopied() + " to groups " + targetGroup);
                this.LOG.debug("IUMSyncJob removed #" + processResult.getUserRemoved() + " from groups " + targetGroup);
            }
            this.iumHelperCacheService.removeAllCache();
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        return processResultList;
    }

    private ProcessResult processPair(String sourceGroups, String targetGroup, Set<ConfluenceUser> confluenceUserAccess) {
        String[] arrayEnableGroups;
        String[] stringArray = arrayEnableGroups = IUMSyncJob.isEmpty(sourceGroups) ? null : sourceGroups.split(";");
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMSyncJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("SyncJob", sourceGroups, targetGroup);
        if (arrayEnableGroups != null && arrayEnableGroups.length > 0 && targetGroup != null && targetGroup.length() > 0) {
            List<ConfluenceUser> targetUsers;
            Group confluenceTargetGroup;
            try {
                confluenceTargetGroup = this.helperService.getGroupByName(targetGroup);
                targetUsers = this.helperService.getUsersFromGroup(confluenceTargetGroup);
            }
            catch (Exception ex) {
                this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                return processResult;
            }
            ArrayList sourceUsers = new ArrayList();
            for (String group : arrayEnableGroups) {
                try {
                    sourceUsers.addAll(this.helperService.getUsersFromGroup(group).stream().filter(usr -> this.disabledUserManager != null ? !this.disabledUserManager.isDisabled(usr.getName()) : true).collect(Collectors.toList()));
                }
                catch (Exception ex) {
                    this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                }
            }
            Set targetUserSet = targetUsers.stream().collect(Collectors.toSet());
            Set sourceUserSet = sourceUsers.stream().collect(Collectors.toSet());
            Sets.SetView set2AddView = Sets.difference((Set)Sets.difference(sourceUserSet, targetUserSet), confluenceUserAccess);
            Sets.SetView set2RemoveView = Sets.difference((Set)Sets.difference(targetUserSet, sourceUserSet), confluenceUserAccess);
            try {
                Set confluenceUsers = set2AddView.stream().collect(Collectors.toSet());
                this.helperService.addUsersToGroup(set2AddView.stream().collect(Collectors.toSet()), confluenceTargetGroup);
                processResult.setUserCopied(confluenceUsers.size());
                if (this.LOG.isInfoEnabled()) {
                    this.LOG.info("IUMSyncJob added users# {} to groups {} ", new Object[]{confluenceUsers.size(), targetGroup});
                }
            }
            catch (Exception e) {
                this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
            }
            processResult.setUserRemoved(0L);
            set2RemoveView.stream().forEach(user -> {
                try {
                    this.helperService.removeUserFromGroup((ConfluenceUser)user, confluenceTargetGroup);
                    processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info("IUMSyncJob removed user {} to groups {} ", new Object[]{user.getName(), targetGroup});
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            });
        } else {
            this.LOG.warn("IUMSyncJob skipped Empty Source/Target config");
        }
        return processResult;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

