var IUMLogout = new function() {
	var self=this;
	var theTimer;
	var INTERVAL=15000;
	const DELTA=300;
	const MINUTE=60 * 1000;
	const DEBUG=false;
	const IUM_CHECK_ACCESS_PING='confluence_ium_check_access_ping'
	const IUM_CHECK_ACCESS_LOGOUT='confluence_ium_check_access_logout'
	var the403Patch=0;
	var theLastUserName;
	//cache latest permission to compare with current

	var logout=function(force){
		if(!force && self.theLastUserName){
			document.location.href=AJS.contextPath() + "/secure/disable?username="+self.theLastUserName;
		}else {
			document.location.href=AJS.$("#log_out").attr("href");
		}
	}
	
	var checkApplicationAccess=function(){
		//1. header
		var userName=AJS.Meta.get("remote-user");
		//2.meta
		if(!userName) {userName=AJS.$("meta[name='ajs-remote-user']").attr('content');}
		if(!userName) {userName=AJS.$("#user-menu-link").attr("data-username");}

		if (typeof (userName)=="undefined"){
			clearInterval(theTimer);
		} else {
			self.theLastUserName=userName;
			var dateNow = Date.now();
			var dateStr = window.localStorage.getItem(IUM_CHECK_ACCESS_PING);
			var dateRef =null;
			if(dateStr){
				try {
					dateRef = JSON.parse(dateStr);
					var dateDiff = dateNow - dateRef.timestamp;
					if(DEBUG){
						console.log("CHK:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
					}

					if (((Math.abs(dateDiff - INTERVAL) > DELTA) && (dateDiff < INTERVAL + 2 * DELTA)) && (dateRef.username === userName)) {
						if(DEBUG){
							console.log("BKP:" + (new Date(dateNow).toISOString().slice(-13, -5)) + " / " + (new Date(dateRef.timestamp).toISOString().slice(-13, -5)) + " Access diff " + (dateNow - dateRef.timestamp));
						}
						doProcessData(dateRef, false);
						return;
					}
				} catch (error) {
					console.error(error);
					dateRef =null;
				}
			}


			if(DEBUG){
				if(dateRef && dateRef.timestamp){
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)) + " / " + ( new Date(dateRef.timestamp).toISOString().slice(-13, -5))  +  " Access diff " +(dateNow - dateRef.timestamp) );
				}else{
					console.log("NET:" +( new Date().toISOString().slice(-13, -5)));
				}
			}

			self.ajaxGetCall(AJS.contextPath() + "/rest/IUM/latest/apps/active");
		}	
	}
	
	this.startLogoutWatcher=function(period){
		the403Patch=0;
		period = period ? period * MINUTE : MINUTE;
		INTERVAL =Math.ceil( period/4);
		INTERVAL= INTERVAL<MINUTE ? INTERVAL :MINUTE;

		theTimer=setInterval(checkApplicationAccess, INTERVAL);

		window.addEventListener('storage', function(event) {
			// Check the changed key and react accordingly
			if (event.key === IUM_CHECK_ACCESS_LOGOUT) {
				var datRef =JSON.parse(event.newValue);
				if(self.theLastUserName === datRef.username){
					logout();
				}
			}
		});
	}

	var callLogout=function(force){
		the403Patch=0;
		clearInterval(theTimer);
		var dateRef={username:self.theLastUserName, timestamp:Date.now()};
		window.localStorage.setItem(IUM_CHECK_ACCESS_LOGOUT,JSON.stringify(dateRef));
		logout(force);
		console.log("ACCXIA IUM: User has been logged out");
	}

	var doProcessData=function(data,withSaving){
		if (!data ){
			callLogout();
			return
		}
		// console.warn("data="+ JSON.stringify(data));
		if (Object.keys(data).length==0){
			callLogout();
			return;
		}
		try {

			//we have data valid
			//our special case ?
			if(!data.username && !data.enabled){
				the403Patch++;
				if (the403Patch > 2) {
					callLogout();
				}
				return
			}

			if (!data.enabled){
				callLogout();
				return
			}

			the403Patch=0;

		}finally {
			if(withSaving){
				data.timestamp = Date.now();
				window.localStorage.setItem(IUM_CHECK_ACCESS_PING,JSON.stringify(data));
				if(DEBUG){
					console.log("SAVE:" + ( new Date(data.timestamp).toISOString().slice(-13, -5))  +  " data=" +JSON.stringify(data) );
				}
			}
		}
	}

	this.ajaxGetCall = function(url) {
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				doProcessData(data,true)
			},
			error :function (xhr, ajaxOptions, thrownError) {
				if (xhr.status >= 400 || errorThrown ) {
					// {"message":"Client must be authenticated to access this resource.","status-code":401}   Unauthorized
					if(xhr.status==401){
						callLogout(true);
						return;
					}

					callLogout();
				}
			}
		});
	};

	this.loadConfig4Watcher=function(){
		var url = AJS.contextPath() + "/rest/IUM/latest/apps/interval";
		jQuery.ajax({
			url : url,
			dataType : 'json',
			contentType: "application/json; charset=utf-8",
			async : true,
			success : function(data) {
				var duration = 1;
				try{
					duration=parseInt(data);
				}catch (err){
					duration=1;
				}
				IUMLogout.startLogoutWatcher(duration);
			},
			error :function (xhr, textStatus, errorThrown ) {
				console.warn("data="+ JSON.stringify(textStatus));
				IUMLogout.startLogoutWatcher(1);
			}
		});
	}
};

AJS.$( document ).ready(function() {
	IUMLogout.loadConfig4Watcher();
});