/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMClusterJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMClusterJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMClusterJob instance;
    private IUMHelperService helperService;
    private JobResultRepository jobResultRepository;

    private IUMClusterJob() {
    }

    public static IUMClusterJob getInstance() {
        if (instance == null) {
            instance = new IUMClusterJob();
        }
        return instance;
    }

    @Override
    public void injectService(IUMHelperService helperService, JobResultRepository jobResultRepository) {
        this.helperService = helperService;
        this.jobResultRepository = jobResultRepository;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        long inactivityInterval = (Long)parameters.get("inactivity_interval");
        if (inactivityInterval <= 0L) {
            inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_INTERVAL;
        }
        String enableGroups = DAO.getIUMGroups();
        String disableGroups = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", enableGroups, disableGroups);
        if (StringUtils.isEmpty((String)enableGroups)) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMClusterJob Empty enableGroup --> skip at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            return processResultList;
        }
        long refTS = System.currentTimeMillis() - inactivityInterval;
        processResult.setUserRemoved(0L);
        List<ConfluenceUser> inactiveUsers = this.helperService.getOnlyEnabledUsers(refTS);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMClusterJob inactiveUsers={} refTS={}", (Object)inactiveUsers.size(), (Object)refTS);
        }
        for (ConfluenceUser user : inactiveUsers) {
            this.helperService.removeUserFromGroup(user, enableGroups);
            processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMClusterJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        processResultList.add(processResult);
        return processResultList;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }
}

