/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.search;

import com.atlassian.confluence.user.SearchEntitiesManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.EntityException;
import com.atlassian.user.Group;
import com.atlassian.user.GroupManager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.search.page.PagerUtils;
import com.atlassian.user.search.query.EntityQueryException;
import com.atlassian.user.search.query.GroupNameTermQuery;
import com.atlassian.user.search.query.Query;
import com.atlassian.user.search.query.TermQuery;
import de.accxia.apps.confluence.ium.search.GroupBean;
import de.accxia.apps.confluence.ium.search.GroupResults;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/gsearch")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class SearchRestController {
    private static final Logger LOG = LoggerFactory.getLogger(SearchRestController.class);
    private SearchEntitiesManager searchEntitiesManager;
    @ComponentImport
    private final UserAccessor userAccessor;
    @ComponentImport
    private final GroupManager groupManager;
    private final IUMHelperService helperService;

    @Inject
    public SearchRestController(IUMHelperService helperService, UserAccessor userAccessor, GroupManager groupManager) {
        if (this.searchEntitiesManager == null) {
            this.searchEntitiesManager = (SearchEntitiesManager)ComponentLocator.getComponent(SearchEntitiesManager.class);
        }
        LOG.info("searchEntitiesManager " + (this.searchEntitiesManager == null ? " NULL " : " NON-NULL "));
        this.userAccessor = userAccessor;
        this.groupManager = groupManager;
        this.helperService = helperService;
    }

    @Path(value="/groups")
    @GET
    @Produces(value={"application/json"})
    public Response searchByGroupName(@QueryParam(value="searchTerm") String searchTerm) {
        List groups;
        if (StringUtils.isBlank((CharSequence)searchTerm)) {
            groups = this.userAccessor.getGroupsAsList();
        } else {
            try {
                String[] tokens;
                ArrayList<TermQuery> searchTerms = new ArrayList<TermQuery>();
                for (String token : tokens = searchTerm.trim().split("[\\s,]+")) {
                    String tokenWithWildcards = this.appendWildcard(token);
                    searchTerms.add(this.searchEntitiesManager.getTermQuery(tokenWithWildcards, GroupNameTermQuery.class));
                }
                Query query = this.searchEntitiesManager.createUserQuery(searchTerms, "match any");
                groups = PagerUtils.toList((Pager)this.userAccessor.findGroups(query).pager());
            }
            catch (EntityQueryException e) {
                LOG.info("Group search construction failed: " + e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            catch (EntityException e) {
                LOG.info("Group search failed: " + e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        return Response.ok((Object)this.convertResultsToSelect2(groups)).build();
    }

    @Path(value="/groups2")
    @GET
    @Produces(value={"application/json"})
    public Response searchByNoAccessGroupName(@QueryParam(value="searchTerm") String searchTerm) {
        List groups;
        if (StringUtils.isBlank((CharSequence)searchTerm)) {
            groups = this.userAccessor.getGroupsAsList();
        } else {
            try {
                String[] tokens;
                ArrayList<TermQuery> searchTerms = new ArrayList<TermQuery>();
                for (String token : tokens = searchTerm.trim().split("[\\s,]+")) {
                    String tokenWithWildcards = this.appendWildcard(token);
                    searchTerms.add(this.searchEntitiesManager.getTermQuery(tokenWithWildcards, GroupNameTermQuery.class));
                }
                Query query = this.searchEntitiesManager.createUserQuery(searchTerms, "match any");
                groups = PagerUtils.toList((Pager)this.userAccessor.findGroups(query).pager());
            }
            catch (EntityQueryException e) {
                LOG.info("Group search construction failed: " + e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
            catch (EntityException e) {
                LOG.info("Group search failed: " + e.getMessage(), (Throwable)e);
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            }
        }
        groups = this.filterNoAccessGroupName(groups);
        return Response.ok((Object)this.convertResultsToSelect2(groups)).build();
    }

    private List<Group> filterNoAccessGroupName(List<Group> groups) {
        Map<String, String> mapConfluenceGroups = this.helperService.getConfluenceGroups().stream().collect(Collectors.toMap(g -> g, g -> g));
        List<Group> filterGroups = groups.stream().filter(grp -> !mapConfluenceGroups.containsKey(grp.getName())).limit(10L).collect(Collectors.toList());
        return filterGroups;
    }

    protected String appendWildcard(String s) {
        if (!s.endsWith("*")) {
            s = s + "*";
        }
        if (!s.startsWith("*")) {
            s = "*" + s;
        }
        return s;
    }

    private GroupResults convertResultsToSelect2(List<Group> groups) {
        GroupResults groupResults = new GroupResults(GroupBean.convertToGroupBeans(groups));
        return groupResults;
    }
}

