/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMSyncJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sjob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobSyncRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobSyncRestController.class);
    public static final String PLUGIN_KEY = "de.accxia.apps.confluence.IUM.IUM4Confluence";
    public static final String GROUP_ID = "de.accxia.apps.confluence.ium.job";
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final DisabledUserManager disabledUserManager;
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final JobResultRepository jobResultRepository;
    private static LocalThread localThread = null;

    @Inject
    public JobSyncRestController(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, IUMHelperService helperService, LocalNotificationService notificationService) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.helperService = helperService;
        this.notificationService = notificationService;
        this.disabledUserManager = (DisabledUserManager)ComponentLocator.getComponent(DisabledUserManager.class);
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("repeat_interval", DAO.getRepeatInterval());
        map.put("starting_from", DAO.getStartingFrom());
        map.put("enable_groups", DAO.getIUMGroups());
        map.put("disable_groups", DAO.getIUMGroupsDisabled());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMSyncJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMSyncJob.class) != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails(IUMSyncJob.class).toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMSyncJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMSyncJob.class)) {
            map.put("lastRunForJob", this.monitorJobRunner.getLastRunForJob(IUMSyncJob.class).toString());
            map.put("lastSuccessfulRunForJob", this.monitorJobRunner.getLastSuccessfulRunForJob(IUMSyncJob.class).toString());
            map.put("nextRunDate", this.monitorJobRunner.getNextRunDate(IUMSyncJob.class).toString());
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateRepeatInterval(repeatinterval);
        DAO.updateStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            IUMSyncJob.getInstance().injectService(this.helperService, this.jobResultRepository);
            IUMSyncJob.getInstance().injectService(this.disabledUserManager);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMSyncJobData(), IUMSyncJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMSyncJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobSyncRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            long duration = Long.parseLong(DAO.getInactivityDuration()) * 60L * 1000L;
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("source_all_groups", (Serializable)((Object)DAO.getSyncAllSrcGoups()));
            parameters.put("target_all_group", (Serializable)((Object)DAO.getSyncAllTargetGoups()));
            parameters.put("inactivity_interval", Long.valueOf(duration));
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            parameters.put("current_user", (Serializable)((Object)(currentUser != null ? currentUser.getName() : "IUMPlugin")));
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobSyncRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobSyncRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobSyncRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobSyncRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    public void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        ConfluenceUser currentUser;
        List<ProcessResult> processResultList = null;
        long elapsedTime;
        String errorMessage;
        boolean isWorking;

        public LocalThread(ConfluenceUser currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                localThread.isWorking = true;
                IUMSyncJob.getInstance().injectService(JobSyncRestController.this.helperService, JobSyncRestController.this.jobResultRepository);
                IUMSyncJob.getInstance().injectService(JobSyncRestController.this.disabledUserManager);
                List<ProcessResult> processResultList = IUMSyncJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                this.elapsedTime = stopTime - startTime;
                localThread.processResultList = processResultList;
                JobSyncRestController.this.doSaveProcessResultList(processResultList, this.parameters, this.elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                localThread.isWorking = false;
            }
        }
    }
}

