/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.conditions;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.sal.api.user.UserManager;
import de.accxia.apps.confluence.ium.conditions.IsUserInGroupsConditionBase;
import de.accxia.apps.confluence.ium.config.DAO;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class IsUserInGroupsCondition
extends IsUserInGroupsConditionBase {
    private static final Logger LOG = LoggerFactory.getLogger(IsUserInGroupsCondition.class);

    @Inject
    public IsUserInGroupsCondition(UserManager userManager, UserAccessor userAccessor) {
        super(userManager, userAccessor);
    }

    protected boolean isConditionTrue() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            return false;
        }
        if (this.isUserInGroups(user.getName(), DAO.getIUMGroupsDisabled())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("IsUserInGroupsCondition user " + user.getName() + " is in groups=" + DAO.getIUMGroupsDisabled());
            }
            return false;
        }
        return true;
    }

    @Override
    protected String queryKey() {
        return "IUM-UserInGroupsCondition";
    }
}

