/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.mywork.model.Notification;
import com.atlassian.mywork.model.NotificationBuilder;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.status.JobDetails;
import com.atlassian.scheduler.status.RunDetails;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExportAsService(value={MonitorJobRunnerImpl.class})
@Named(value="monitorJobRunner")
public class MonitorJobRunnerImpl
implements MonitorJobRunner {
    private static Logger LOG = LoggerFactory.getLogger(MonitorJobRunnerImpl.class);
    public static final String JOB_ID = "JOB_ID";
    public static final String PLUGIN_KEY = "de.accxia.apps.confluence.IUM.IUM4Confluence";
    public static final String GROUP_ID = "de.accxia.apps.confluence.ium.job";
    private final ConcurrentHashMap<JobId, JobRunnerKeyDetail> map;
    @ConfluenceImport
    private final SchedulerService confluenceSchedulerService;
    @ComponentImport
    private final LocalNotificationService notificationService;
    private RunDetailsDao runDetailsDao;
    private DisabledUserManager disabledUserManager;
    private final IUMHelperService helperService;
    private final JobResultRepository jobResultRepository;

    @Inject
    public MonitorJobRunnerImpl(SchedulerService confluenceSchedulerService, IUMHelperService helperService, JobResultRepository jobResultRepository, LocalNotificationService notificationService) {
        this.confluenceSchedulerService = confluenceSchedulerService;
        this.map = new ConcurrentHashMap();
        this.helperService = helperService;
        this.notificationService = notificationService;
        this.jobResultRepository = jobResultRepository;
        try {
            this.runDetailsDao = (RunDetailsDao)ComponentLocator.getComponent(RunDetailsDao.class);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
        try {
            this.disabledUserManager = (DisabledUserManager)ComponentLocator.getComponent(DisabledUserManager.class);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String doSchedule(JobData jobData, final IJob job) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)job.getClass().getName());
        JobRunnerKeyDetail jobRunnerKeyDetail = this.getOrCreateJob(jobId);
        this.confluenceSchedulerService.registerJobRunner(jobRunnerKeyDetail.jobRunnerKey, new JobRunner(){

            @Nullable
            public JobRunnerResponse runJob(JobRunnerRequest jobRequest) {
                try {
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Begin ProcessingJob at " + new Date());
                    }
                    MonitorJobRunnerImpl.this.doProcessingJob(job, jobRequest.getJobConfig().getParameters());
                    if (LOG.isInfoEnabled()) {
                        LOG.info("End ProcessingJob at " + new Date());
                    }
                }
                catch (Exception e) {
                    LOG.error("Exception ProcessingJob: " + e.getMessage(), (Throwable)e);
                    return JobRunnerResponse.aborted((String)("Task aborted due to the following error : " + e.getMessage()));
                }
                return JobRunnerResponse.success();
            }
        });
        jobData.getParameters().put(JOB_ID, (Serializable)((Object)jobId.toString()));
        jobRunnerKeyDetail.nextRunDate = this.createFirstRunDate(jobData.getRepeatInterval(), jobData.getStartingFrom());
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKeyDetail.jobRunnerKey).withRunMode(RunMode.RUN_LOCALLY).withParameters(jobData.getParameters()).withSchedule(Schedule.forInterval((long)jobData.getRepeatInterval(), (Date)jobRunnerKeyDetail.nextRunDate));
        try {
            this.confluenceSchedulerService.scheduleJob(jobId, jobConfig);
            LOG.warn("Job schedule with id =" + jobId.toString());
            return jobRunnerKeyDetail.jobRunnerKey.toString();
        }
        catch (Exception e) {
            LOG.error("Exception: " + e.getMessage(), (Throwable)e);
            throw new SchedulerServiceException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void doUnSchedule(Class classz) throws SchedulerServiceException {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            LOG.warn("Stopping..." + jobRunnerKeyDetail.jobRunnerKey);
            this.confluenceSchedulerService.unscheduleJob(jobId);
            this.getOrCreateJob((JobId)jobId).nextRunDate = null;
        }
    }

    @Override
    public JobDetails getJobDetails(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.confluenceSchedulerService.getJobDetails(jobId);
        }
        return null;
    }

    @Override
    public Date getNextRunDate(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate;
        }
        return null;
    }

    @Override
    public RunDetails getLastRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.runDetailsDao.getLastRunForJob(jobId);
        }
        return null;
    }

    @Override
    public RunDetails getLastSuccessfulRunForJob(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            return this.runDetailsDao.getLastRunForJob(jobId);
        }
        return null;
    }

    @Override
    public boolean isWorking(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    @Override
    public List<JobDetails> getJobsByJobRunnerKey(Class classz) {
        JobId jobId = JobId.of((String)classz.getName());
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return this.confluenceSchedulerService.getJobsByJobRunnerKey(jobRunnerKeyDetail.jobRunnerKey);
        }
        return Collections.EMPTY_LIST;
    }

    private void doProcessingJob(IJob job, Map<String, Serializable> parameters) {
        if (job != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ProcessingJob parameters ");
                for (Map.Entry<String, Serializable> parameter : parameters.entrySet()) {
                    LOG.debug("key: " + parameter.getKey() + " = " + parameter.getValue());
                }
            }
            long startTime = System.currentTimeMillis();
            String className = (String)((Object)parameters.get(JOB_ID));
            JobId jobId = JobId.of((String)className);
            job.injectService(this.helperService, this.jobResultRepository);
            job.injectService(this.disabledUserManager);
            List<ProcessResult> processResultList = job.doProcessingJob(parameters);
            long stopTime = System.currentTimeMillis();
            long elapsedTime = stopTime - startTime;
            this.doEmitSystemNotification(parameters, this.createPlainMessage(processResultList, elapsedTime));
            this.doSaveProcessResultList(processResultList, parameters, elapsedTime);
            Schedule schedule = this.confluenceSchedulerService.getJobDetails(jobId).getSchedule();
            if (schedule != null) {
                long timeInSecs = System.currentTimeMillis();
                Date nextRunDate = new Date(timeInSecs + schedule.getIntervalScheduleInfo().getIntervalInMillis());
                LOG.warn("nextRunDate= " + nextRunDate);
                this.getOrCreateJob((JobId)jobId).nextRunDate = nextRunDate;
            }
        } else {
            LOG.warn("ProcessingJob NO JOB");
        }
    }

    private String createPlainMessage(List<ProcessResult> processResultList, long elapsedTime) {
        StringBuffer sb = new StringBuffer();
        sb.append("Status:Done").append("\n");
        for (ProcessResult processResult : processResultList) {
            sb.append(String.format("Copy From %s to %s #%d", processResult.getSourceGroups(), processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
            sb.append(String.format("Remove From %s #%d", processResult.getTargetGroup(), processResult.getUserCopied())).append("\n");
        }
        sb.append(String.format("Duration %5.1f", (double)elapsedTime / 60.0 / 1000.0)).append(" minutes");
        return sb.toString();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    private boolean isRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            return jobRunnerKeyDetail.nextRunDate != null;
        }
        return false;
    }

    private boolean stopRunning(JobId jobId) {
        if (this.map.containsKey(jobId) && this.map.get(jobId) != null) {
            JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
            jobRunnerKeyDetail.nextRunDate = null;
            return true;
        }
        return false;
    }

    private JobRunnerKeyDetail getOrCreateJob(String className) {
        JobId jobId = JobId.of((String)className);
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(className));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private JobRunnerKeyDetail getOrCreateJob(JobId jobId) {
        if (!this.map.containsKey(jobId) || this.map.get(jobId) == null) {
            this.map.put(jobId, new JobRunnerKeyDetail(jobId.toString()));
        }
        JobRunnerKeyDetail jobRunnerKeyDetail = this.map.get(jobId);
        return jobRunnerKeyDetail;
    }

    private Date createFirstRunDate(long repeatInterval, int hour) {
        Random random = new Random();
        int randomNum = (random.nextInt(3) + 3) * 1000;
        if (repeatInterval <= 300000L) {
            long currentTimeMillis = System.currentTimeMillis();
            return new Date(currentTimeMillis + (long)randomNum);
        }
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(11) >= hour) {
            calendar.set(5, calendar.get(5) + 1);
        }
        calendar.set(11, hour);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        long calendarTimeMillis = calendar.getTime().getTime();
        return new Date(calendarTimeMillis + (long)randomNum);
    }

    private void doEmitSystemNotification(Map<String, Serializable> parameters, String body) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        try {
            if (currentUser != null) {
                this.sendNotification(currentUser, "Automatic User Sync Job", body);
            }
        }
        catch (Exception e) {
            LOG.error(" " + e.getMessage(), (Throwable)e);
        }
    }

    private Notification sendNotification(String user, String title, String message) throws InterruptedException, ExecutionException {
        Notification notification = (Notification)this.notificationService.createOrUpdate(user, new NotificationBuilder().application(PLUGIN_KEY).title("Sync Job").itemTitle(title).description(message).groupingId(GROUP_ID).createNotification()).get();
        return notification;
    }

    class JobRunnerKeyDetail {
        public JobRunnerKey jobRunnerKey;
        public Date nextRunDate = null;

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey, Date nextRunDate) {
            this.jobRunnerKey = jobRunnerKey;
            this.nextRunDate = nextRunDate;
        }

        public JobRunnerKeyDetail(JobRunnerKey jobRunnerKey) {
            this(jobRunnerKey, null);
        }

        public JobRunnerKeyDetail(String className) {
            this.jobRunnerKey = JobRunnerKey.of((String)className);
            this.nextRunDate = null;
        }
    }
}

