/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.JobData;
import de.accxia.apps.confluence.ium.job.Mutex;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMWatcherJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMWatcherJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMWatcherJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    public static final double THRESHOLD = 0.9;

    private IUMWatcherJob() {
    }

    public static IUMWatcherJob getInstance() {
        if (instance == null) {
            instance = new IUMWatcherJob();
        }
        return instance;
    }

    @Override
    public void injectService(IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMWatcherJob.instance.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.jobResultRepository = jobResultRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ProcessResult> doProcessingJob(final Map<String, Serializable> parameters) {
        boolean locked = false;
        try {
            List processResults;
            locked = Mutex.MUTEX.tryLock(100L, TimeUnit.MILLISECONDS);
            ExecutorService executorService = Executors.newSingleThreadExecutor();
            Future retVal = executorService.submit(new Callable(){

                public List<ProcessResult> call() throws Exception {
                    return IUMWatcherJob.this.doLocalProcessingJob(parameters);
                }
            });
            List list = processResults = (List)retVal.get();
            return list;
        }
        catch (Exception e) {
            this.LOG.error("IUMClusterJob Process #[" + SDF.format(new Date()) + "] " + e.getMessage(), (Throwable)e);
            e.printStackTrace();
        }
        finally {
            if (locked) {
                Mutex.MUTEX.unlock();
            }
        }
        return Collections.emptyList();
    }

    public List<ProcessResult> doLocalProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMWatcherJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        long inactivityInterval = JobData.DEFAULT_USER_INACTIVITY_SHORT_INTERVAL;
        String enableGroups = DAO.getIUMGroups();
        String disableGroups = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMWatcherJob Process with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("CleanJob", enableGroups, disableGroups);
        if (StringUtils.isEmpty((String)enableGroups)) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMWatcherJob Empty enableGroup --> skip at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            return processResultList;
        }
        long refTS = System.currentTimeMillis() - inactivityInterval;
        processResult.setUserRemoved(0L);
        String[] groups = enableGroups.split(",");
        String[] sizes = DAO.getQueueSize().split(",");
        boolean shouldRun = false;
        for (int i = 0; i < groups.length; ++i) {
            int cnt = 0;
            if (sizes.length >= i + 1 || (cnt = this.safeParseToInt(sizes[i])) <= 0 || !((double)cnt * 0.9 > (double)this.iumHelperCacheService.countFromCacheUsersForGroup(groups[i]))) continue;
            shouldRun = true;
            break;
        }
        if (!shouldRun) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMWatcherJob Empty enableGroup --> skip at [ {} ] ", new Object[]{SDF.format(new Date())});
            }
            return processResultList;
        }
        List<String> inactiveUsers = this.helperService.getInactiveUsers4EnabledGroups(refTS, 50);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMWatcherJob inactiveUsers={} refTS={}", (Object)inactiveUsers.size(), (Object)refTS);
        }
        for (String userName : inactiveUsers) {
            try {
                TimeUnit.MILLISECONDS.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.helperService.removeUserFromGroup(userName, enableGroups);
            this.iumHelperCacheService.removeUserAccessFromCache(userName);
            processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
        }
        this.iumHelperCacheService.removeGroupAccessFromCache(enableGroups);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMWatcherJob Processed with groups={} interval={} at [ {} ] ", new Object[]{enableGroups, inactivityInterval, SDF.format(new Date())});
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMWatcherJob Processed #[" + SDF.format(new Date()) + "] ");
        }
        processResultList.add(processResult);
        return processResultList;
    }

    private static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

