/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.status.JobDetails;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IUMWatcherJob;
import de.accxia.apps.confluence.ium.job.JobDataUtils;
import de.accxia.apps.confluence.ium.job.MonitorJobRunner;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.model.JobResultDTO;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/wjob")
@Consumes(value={"text/html", "application/json"})
@Produces(value={"application/json"})
@Named
public class JobWatchRestController {
    private static final Logger LOG = LoggerFactory.getLogger(JobWatchRestController.class);
    @ComponentImport
    private final LocalNotificationService notificationService;
    private final MonitorJobRunner monitorJobRunner;
    private final IUMHelperService helperService;
    private final IUMHelperCacheService iumHelperCacheService;
    private final JobResultRepository jobResultRepository;
    private static LocalThread localThread = null;

    @Inject
    public JobWatchRestController(MonitorJobRunner monitorJobRunner, JobResultRepository jobResultRepository, IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, LocalNotificationService notificationService) {
        this.monitorJobRunner = monitorJobRunner;
        this.jobResultRepository = jobResultRepository;
        this.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        this.notificationService = notificationService;
    }

    @Path(value="/config")
    @GET
    @Produces(value={"application/json"})
    public Response getCurrentConfig() {
        List<JobDetails> details;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("daily_repeat_interval", DAO.getDailyRepeatInterval());
        map.put("daily_starting_from", DAO.getDailyStartingFrom());
        map.put("working", String.valueOf(this.monitorJobRunner.isWorking(IUMWatcherJob.class)));
        if (this.monitorJobRunner.getJobDetails(IUMWatcherJob.class) != null) {
            map.put("jobDetails", this.monitorJobRunner.getJobDetails(IUMWatcherJob.class).toString());
        }
        if ((details = this.monitorJobRunner.getJobsByJobRunnerKey(IUMWatcherJob.class)) != null) {
            for (int i = 0; i < details.size(); ++i) {
                map.put("jobDetails" + i, details.get(i).toString());
            }
        }
        if (this.monitorJobRunner.isWorking(IUMWatcherJob.class)) {
            map.put("lastRunForJob", this.monitorJobRunner.getLastRunForJob(IUMWatcherJob.class) != null ? this.monitorJobRunner.getLastRunForJob(IUMWatcherJob.class).toString() : "N/A");
            map.put("lastSuccessfulRunForJob", this.monitorJobRunner.getLastSuccessfulRunForJob(IUMWatcherJob.class) != null ? this.monitorJobRunner.getLastSuccessfulRunForJob(IUMWatcherJob.class).toString() : "N/A");
            map.put("nextRunDate", this.monitorJobRunner.getNextRunDate(IUMWatcherJob.class) != null ? this.monitorJobRunner.getNextRunDate(IUMWatcherJob.class).toString() : "N/A");
        }
        return Response.ok(map).build();
    }

    @Path(value="/config")
    @POST
    @Produces(value={"application/json"})
    public Response setCurrentConfig(@QueryParam(value="repeat_interval") String repeatinterval, @QueryParam(value="starting_from") String startingFrom) {
        DAO.updateDailyRepeatInterval(repeatinterval);
        DAO.updateDailyStartingFrom(startingFrom);
        return this.getCurrentConfig();
    }

    @Path(value="/start")
    @GET
    @Produces(value={"application/json"})
    public Response startDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            IUMWatcherJob.getInstance().injectService(this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            String jobKey = this.monitorJobRunner.doSchedule(JobDataUtils.createFakeIUMWatcherJobData(), IUMWatcherJob.getInstance());
            if (LOG.isDebugEnabled()) {
                LOG.debug("jobKey= " + jobKey);
            }
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/stop")
    @GET
    @Produces(value={"application/json"})
    public Response stopDebugJob() {
        try {
            this.monitorJobRunner.doUnSchedule(IUMWatcherJob.class);
            return Response.ok((Object)"success").build();
        }
        catch (SchedulerServiceException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    @Path(value="/runnow")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsJob() {
        if (localThread != null && JobWatchRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("daily_repeat_interval", (Serializable)((Object)DAO.getDailyRepeatInterval()));
            parameters.put("daily_starting_from", (Serializable)((Object)DAO.getDailyStartingFrom()));
            ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
            parameters.put("current_user", (Serializable)((Object)(currentUser != null ? currentUser.getName() : "IUMPlugin")));
            localThread = new LocalThread(currentUser, parameters);
            localThread.start();
            IUMWatcherJob.getInstance().injectService(this.helperService, this.iumHelperCacheService, this.jobResultRepository);
            IUMWatcherJob.getInstance().doProcessingJob(parameters);
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobcheck")
    @GET
    @Produces(value={"application/json"})
    public Response runNowsCheckJob() {
        if (localThread == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.ok((Object)response).build();
        }
        if (JobWatchRestController.localThread.isWorking) {
            String response = "{\"message\":\"processing\"}";
            return Response.ok((Object)response).build();
        }
        try {
            if (JobWatchRestController.localThread.errorMessage != null) {
                String response = "{\"message\":\"" + JobWatchRestController.localThread.errorMessage + "\"}";
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
            }
            return Response.ok(JobWatchRestController.localThread.processResultList).build();
        }
        catch (Exception e) {
            String response = "{\"message\":\"" + e.getMessage() + "\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
    }

    @Path(value="/jobresults")
    @GET
    @Produces(value={"application/json"})
    public Response getLatestJobResults() {
        if (this.jobResultRepository == null) {
            String response = "{\"message\":\"not stating\"}";
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)response).build();
        }
        List jobResultDTOList = Arrays.stream(this.jobResultRepository.findAll(0, 10)).map(jobResult -> JobResultDTO.fromAO(jobResult)).collect(Collectors.toList());
        return Response.ok(jobResultDTOList).build();
    }

    private void doSaveProcessResultList(List<ProcessResult> processResultList, Map<String, Serializable> parameters, long elapsedTime) {
        String currentUser = (String)((Object)parameters.get("current_user"));
        for (ProcessResult processResult : processResultList) {
            this.jobResultRepository.save(JobResultDTO.createJobResult(processResult, currentUser, elapsedTime));
        }
    }

    class LocalThread
    extends Thread {
        Map<String, Serializable> parameters;
        ConfluenceUser currentUser;
        List<ProcessResult> processResultList = null;
        String errorMessage;
        boolean isWorking;

        public LocalThread(ConfluenceUser currentUser, Map<String, Serializable> parameters) {
            this.parameters = parameters;
            this.currentUser = currentUser;
            this.isWorking = false;
            this.errorMessage = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long startTime = System.currentTimeMillis();
                localThread.isWorking = true;
                IUMWatcherJob.getInstance().injectService(JobWatchRestController.this.helperService, JobWatchRestController.this.iumHelperCacheService, JobWatchRestController.this.jobResultRepository);
                List<ProcessResult> processResultList = IUMWatcherJob.getInstance().doProcessingJob(this.parameters);
                long stopTime = System.currentTimeMillis();
                long elapsedTime = stopTime - startTime;
                localThread.processResultList = processResultList;
                JobWatchRestController.this.doSaveProcessResultList(processResultList, this.parameters, elapsedTime);
            }
            catch (Exception e) {
                LOG.error("Exception: " + e.getMessage(), (Throwable)e);
                try {
                    localThread.errorMessage = e.getMessage();
                }
                catch (Exception ex) {
                    LOG.error("Exception: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException(ex);
                }
            }
            finally {
                localThread.isWorking = false;
            }
        }
    }
}

