/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.servlet.filter;

import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.model.NavUser;
import de.accxia.apps.confluence.ium.model.NavUserDTO;
import de.accxia.apps.confluence.ium.repository.NavUserRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import java.io.IOException;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AccxiaUserSessionTracker {
    private static final Logger LOG = LoggerFactory.getLogger(AccxiaUserSessionTracker.class);
    private NavUserRepository navUserRepository;
    private final ConcurrentHashMap<String, NavUserDTO> userRequestMap;
    private final IUMHelperCacheService iumHelperCacheService;
    private final int MINUTE = 60000;
    private final int MINUTES = 120000;

    @Inject
    public AccxiaUserSessionTracker(NavUserRepository navUserRepository, IUMHelperCacheService iumHelperCacheService) {
        this.navUserRepository = navUserRepository;
        this.iumHelperCacheService = iumHelperCacheService;
        this.userRequestMap = new ConcurrentHashMap();
    }

    public boolean guardInteraction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (userName == null || requestURI == null) {
            return false;
        }
        NavUserDTO navUserDTO = this.userRequestMap.get(userName);
        if (navUserDTO != null && navUserDTO.getLastAccessTime() != null && requestURI.contains("rest/IUM/latest/apps/check")) {
            int duration = this.safeParseToInt(DAO.getDuration());
            long diff = System.currentTimeMillis() - navUserDTO.getLastAccessTime().getTime();
            if (duration > 0 && System.currentTimeMillis() - navUserDTO.getLastAccessTime().getTime() > (long)(duration * 120000)) {
                LOG.info("Check " + userName + "  no action " + diff);
                if (this.iumHelperCacheService.checkFillUsersPercentageFromCache(95)) {
                    LOG.info("Check FillUsersPercentage " + userName + "  no action " + diff);
                    httpServletRequest.getSession().invalidate();
                    try {
                        httpServletResponse.sendError(401);
                    }
                    catch (IOException e) {
                        LOG.error("IOException: " + e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public void recordInteraction(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String userName = httpServletRequest.getRemoteUser();
        String requestURI = httpServletRequest.getRequestURI();
        if (userName == null || requestURI == null) {
            return;
        }
        NavUserDTO navUserDTO = this.userRequestMap.get(userName);
        if (!requestURI.contains("/rest/oidc/") && !requestURI.contains("/rest/quickreload/") && (requestURI.contains("/rest/") || requestURI.contains("/synchrony/heartbeat") || requestURI.contains("/json/start"))) {
            return;
        }
        if (this.navUserRepository == null) {
            this.navUserRepository = (NavUserRepository)ComponentLocator.getComponent(NavUserRepository.class);
        }
        if (navUserDTO == null || navUserDTO.getID() == null) {
            navUserDTO = this.buildNavUserDTO(httpServletRequest);
            this.userRequestMap.put(userName, navUserDTO);
        } else {
            navUserDTO.addRequestCount();
            navUserDTO.setLastAccessTime(new Date());
            this.userRequestMap.put(userName, navUserDTO);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CALL " + (httpServletRequest.getRemoteUser() == null ? "N/A" : httpServletRequest.getRemoteUser()) + " " + httpServletRequest.getRequestURI());
        }
        if (this.navUserRepository != null && (navUserDTO.getSavedTime() == null || System.currentTimeMillis() - navUserDTO.getSavedTime().getTime() > 30000L)) {
            Date currentDate = new Date();
            NavUser[] navUsers = this.navUserRepository.getByUserName(navUserDTO.getUserName());
            if (navUsers.length > 0) {
                NavUser refNavUser = navUsers[navUsers.length - 1];
                if (navUsers.length > 1) {
                    this.navUserRepository.deleteOldestExceptUsers(navUserDTO.getUserName(), refNavUser);
                }
                refNavUser = this.navUserRepository.updated(refNavUser, navUserDTO);
                navUserDTO.setID(refNavUser.getID());
                navUserDTO.setSavedTime(currentDate);
            } else {
                NavUser navUser = this.navUserRepository.save(navUserDTO);
                navUserDTO.setID(navUser.getID());
                navUserDTO.setSavedTime(currentDate);
            }
        }
    }

    private NavUserDTO buildNavUserDTO(HttpServletRequest httpServletRequest) {
        NavUserDTO navUserDTO = new NavUserDTO();
        Date now = new Date();
        navUserDTO.setID(null);
        navUserDTO.setRequestCount(1L);
        navUserDTO.setUserName(httpServletRequest.getRemoteUser());
        navUserDTO.setLastAccessTime(now);
        navUserDTO.setCreationTime(now);
        return navUserDTO;
    }

    private int safeParseToInt(String time) {
        if (time == null || time.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(time);
        }
        catch (Exception e) {
            LOG.error("Exception " + e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

