/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.cache;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.memory.MemoryCacheManager;
import com.atlassian.sal.api.component.ComponentLocator;
import de.accxia.apps.confluence.ium.cache.PropertyCacheEntryAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractCachedManager {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCachedManager.class);
    private ApplicationContext applicationContext;
    private CacheManager cacheManager;
    protected PropertyCacheEntryAdapter propertyCacheEntryAdapter = null;

    public AbstractCachedManager(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        if (this.applicationContext == null) {
            throw new IllegalStateException("Error, possible  plugin should not start correct");
        }
        if (this.propertyCacheEntryAdapter == null) {
            this.propertyCacheEntryAdapter = (PropertyCacheEntryAdapter)applicationContext.getBean(PropertyCacheEntryAdapter.class);
        }
        if (this.propertyCacheEntryAdapter == null) {
            this.propertyCacheEntryAdapter = (PropertyCacheEntryAdapter)ComponentLocator.getComponent(PropertyCacheEntryAdapter.class);
        }
        if (this.propertyCacheEntryAdapter == null) {
            throw new IllegalStateException("Error, possible  plugin should not start correct");
        }
        this.doInit();
    }

    private ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalStateException("Plugin does not start correct");
        }
        return this.applicationContext;
    }

    private <T> T getBean(Class<T> beanClazz) {
        try {
            return (T)ComponentLocator.getComponent(beanClazz);
        }
        catch (Exception e) {
            LOG.info("NoSuchBeanDefinitionException " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CacheManager getCacheManager() {
        if (this.cacheManager != null) {
            return this.cacheManager;
        }
        this.cacheManager = this.getBean(CacheManager.class);
        if (this.cacheManager != null) {
            LOG.info("CacheManager - class " + this.cacheManager.getClass().getName());
            return this.cacheManager;
        }
        this.cacheManager = new MemoryCacheManager();
        LOG.info("CacheManager- class " + this.cacheManager.getClass().getName());
        return this.cacheManager;
    }

    protected abstract void doInit();
}

