/*
 * Decompiled with CFR 0.152.
 */
package de.accxia.apps.confluence.ium.job;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.DisabledUserManager;
import com.atlassian.user.Group;
import com.google.common.collect.Sets;
import de.accxia.apps.confluence.ium.config.DAO;
import de.accxia.apps.confluence.ium.job.IJob;
import de.accxia.apps.confluence.ium.job.ProcessResult;
import de.accxia.apps.confluence.ium.repository.JobResultRepository;
import de.accxia.apps.confluence.ium.util.IUMHelperCacheService;
import de.accxia.apps.confluence.ium.util.IUMHelperService;
import de.accxia.apps.confluence.ium.util.ParseUtil;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IUMDailyJob
implements IJob {
    private Logger LOG = LoggerFactory.getLogger(IUMDailyJob.class);
    private static SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static IUMDailyJob instance;
    private IUMHelperService helperService;
    private IUMHelperCacheService iumHelperCacheService;
    private JobResultRepository jobResultRepository;
    private DisabledUserManager disabledUserManager;
    int syncUsers = 0;

    private IUMDailyJob() {
    }

    public static IUMDailyJob getInstance() {
        if (instance == null) {
            instance = new IUMDailyJob();
        }
        return instance;
    }

    @Override
    public void injectService(IUMHelperService helperService, IUMHelperCacheService iumHelperCacheService, JobResultRepository jobResultRepository) {
        IUMDailyJob.instance.helperService = helperService;
        this.iumHelperCacheService = iumHelperCacheService;
        IUMDailyJob.instance.jobResultRepository = jobResultRepository;
    }

    @Override
    public void injectService(DisabledUserManager disabledUserManager) {
        this.disabledUserManager = disabledUserManager;
    }

    @Override
    public List<ProcessResult> doProcessingJob(Map<String, Serializable> parameters) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Process #[" + SDF.format(new Date()) + "] ");
        }
        ArrayList<ProcessResult> processResultList = new ArrayList<ProcessResult>();
        String sourceGroups = DAO.getIUMGroups();
        String targetGroup = DAO.getIUMGroupsDisabled();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        if (this.helperService != null && this.jobResultRepository != null && !StringUtils.isEmpty((String)sourceGroups) && !StringUtils.isEmpty((String)targetGroup)) {
            String[] arraySourceGroups = sourceGroups.split(",");
            String[] arrayTargetGroups = targetGroup.split(",");
            Set<ConfluenceUser> confluenceUserAccess = this.helperService.getUsersWithConfluenceAccessOtherIUM();
            this.syncUsers = 0;
            for (int i = 0; i < arraySourceGroups.length; ++i) {
                if (arrayTargetGroups.length <= i || ParseUtil.isEmpty(arraySourceGroups[i]) || ParseUtil.isEmpty(arrayTargetGroups[i])) continue;
                ProcessResult processResult = this.processPair(arraySourceGroups[i], arrayTargetGroups[i], confluenceUserAccess);
                processResultList.add(processResult);
            }
            this.iumHelperCacheService.removeAllCache();
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("IUMDailyJob copied #" + this.syncUsers + " to group " + targetGroup);
            }
        }
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info("IUMDailyJob Processed #[" + SDF.format(new Date()) + "] syncUsers=" + this.syncUsers);
        }
        return processResultList;
    }

    private ProcessResult processPair(String sourceGroups, String targetGroup, Set<ConfluenceUser> confluenceUserAccess) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("IUMDailyJob Sync groups = {} -> {}  at [ {} ] ", new Object[]{sourceGroups, targetGroup, SDF.format(new Date())});
        }
        ProcessResult processResult = new ProcessResult("DailyJob", sourceGroups, targetGroup);
        if (sourceGroups != null && sourceGroups.length() > 0 && targetGroup != null && targetGroup.length() > 0) {
            List<ConfluenceUser> sourceUsers;
            Group confluenceSourceGroup;
            List<ConfluenceUser> targetUsers;
            Group confluenceTargetGroup;
            try {
                confluenceTargetGroup = this.helperService.getGroupByName(targetGroup);
                targetUsers = this.helperService.getUsersFromGroup(confluenceTargetGroup);
            }
            catch (Exception ex) {
                this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                return processResult;
            }
            try {
                confluenceSourceGroup = this.helperService.getGroupByName(sourceGroups);
                sourceUsers = this.helperService.getUsersFromGroup(confluenceSourceGroup);
            }
            catch (Exception ex) {
                this.LOG.error("Exception=" + ex.getMessage(), (Throwable)ex);
                return processResult;
            }
            Set targetUserSet = targetUsers.stream().collect(Collectors.toSet());
            Set sourceUserSet = sourceUsers.stream().collect(Collectors.toSet());
            Set disabledTargetUserSet = targetUsers.stream().filter(usr -> this.disabledUserManager != null ? this.disabledUserManager.isDisabled(usr.getName()) : true).collect(Collectors.toSet());
            Set disabledSourceUserSet = sourceUsers.stream().filter(usr -> this.disabledUserManager != null ? this.disabledUserManager.isDisabled(usr.getName()) : true).collect(Collectors.toSet());
            Sets.SetView setWithoutIUMAccess = Sets.union((Set)Sets.intersection(confluenceUserAccess, sourceUserSet), (Set)Sets.intersection(confluenceUserAccess, targetUserSet));
            Sets.SetView set2RemoveView = Sets.union((Set)Sets.intersection(targetUserSet, (Set)setWithoutIUMAccess), disabledTargetUserSet);
            Sets.SetView set1RemoveView = Sets.union((Set)Sets.intersection(sourceUserSet, (Set)setWithoutIUMAccess), disabledSourceUserSet);
            processResult.setUserRemoved(0L);
            set2RemoveView.stream().forEach(user -> {
                try {
                    this.helperService.removeUserFromGroup((ConfluenceUser)user, confluenceTargetGroup);
                    processResult.setUserRemoved(processResult.getUserRemoved() + 1L);
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info("IUMDailyJob removed user {} from groups   {} ", new Object[]{user.getName(), targetGroup});
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            });
            processResult.setUserCopied(0L);
            set1RemoveView.stream().forEach(user -> {
                try {
                    this.helperService.removeUserFromGroup((ConfluenceUser)user, confluenceSourceGroup);
                    processResult.setUserCopied(processResult.getUserCopied() + 1L);
                    if (this.LOG.isInfoEnabled()) {
                        this.LOG.info("IUMDailyJob removed user {} from groups {} ", new Object[]{user.getName(), targetGroup});
                    }
                }
                catch (Exception e) {
                    this.LOG.error("Exception " + e.getMessage(), (Throwable)e);
                }
            });
        } else {
            this.LOG.warn("IUMSyncJob skipped Empty Source/Target config");
        }
        return processResult;
    }
}

